package com.xforceplus.ultraman.app.unicharm.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 推送状态
 * </p>
 *
 * @author ultraman
 * @since 2021-10-19
 */
public enum ResultCode {

    _0("0", "待推送"),
    _2("2", "推送中"),
    _4("4", "推送成功");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    ResultCode(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ResultCode fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "2":
                return _2;
            case "4":
                return _4;
            default:
                return null;
        }
    }
}
