package com.xforceplus.ultraman.app.unicharm.metadata.dict;


import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 清空折扣方式
 * </p>
 *
 * @author ultraman
 * @since 2021-10-19
 */
public enum ClearDiscountMethod {

    _0("0", "清空价内折扣"),
    _1("1", "清空价外折扣"),
    _2("2", "全部清空");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    ClearDiscountMethod(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ClearDiscountMethod fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "1":
                return _1;
            case "2":
                return _2;
            default:
                return null;
        }
    }
}
