/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.app.upgradeinvoiceservice.metadata.validator;

import com.xforceplus.ultraman.app.upgradeinvoiceservice.metadata.dict.DiscountType;
import com.xforceplus.ultraman.app.upgradeinvoiceservice.metadata.dict.FlowStatus;
import com.xforceplus.ultraman.app.upgradeinvoiceservice.metadata.dict.PlatformFlag;
import com.xforceplus.ultraman.app.upgradeinvoiceservice.metadata.dict.SelectType;
import com.xforceplus.ultraman.app.upgradeinvoiceservice.metadata.dict.SnapshotFormat;
import com.xforceplus.ultraman.app.upgradeinvoiceservice.metadata.validator.annotation.CheckUltramanEnums;
import java.util.Arrays;
import java.util.List;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

public class UltramanEnumsConstraintValidator
implements ConstraintValidator<CheckUltramanEnums, String> {
    private final String MSG_FORMAT = "value must be formed from codes of enum %s";
    Class clazz;

    public void initialize(CheckUltramanEnums constraintAnnotation) {
        this.clazz = constraintAnnotation.value();
    }

    public boolean isValid(String value, ConstraintValidatorContext context) {
        if (null == value || value.length() == 0) {
            return true;
        }
        boolean isValid = true;
        List<String> vals = Arrays.asList(value.split(","));
        if (this.clazz.equals(FlowStatus.class)) {
            boolean bl = isValid = vals.stream().filter(val -> null != FlowStatus.fromCode(val)).count() == (long)vals.size();
            if (!isValid) {
                this.unValidMsg(context, FlowStatus.class.getSimpleName());
            }
        }
        if (this.clazz.equals(SnapshotFormat.class)) {
            boolean bl = isValid = vals.stream().filter(val -> null != SnapshotFormat.fromCode(val)).count() == (long)vals.size();
            if (!isValid) {
                this.unValidMsg(context, SnapshotFormat.class.getSimpleName());
            }
        }
        if (this.clazz.equals(PlatformFlag.class)) {
            boolean bl = isValid = vals.stream().filter(val -> null != PlatformFlag.fromCode(val)).count() == (long)vals.size();
            if (!isValid) {
                this.unValidMsg(context, PlatformFlag.class.getSimpleName());
            }
        }
        if (this.clazz.equals(DiscountType.class)) {
            boolean bl = isValid = vals.stream().filter(val -> null != DiscountType.fromCode(val)).count() == (long)vals.size();
            if (!isValid) {
                this.unValidMsg(context, DiscountType.class.getSimpleName());
            }
        }
        if (this.clazz.equals(SelectType.class)) {
            boolean bl = isValid = vals.stream().filter(val -> null != SelectType.fromCode(val)).count() == (long)vals.size();
            if (!isValid) {
                this.unValidMsg(context, SelectType.class.getSimpleName());
            }
        }
        return isValid;
    }

    private void unValidMsg(ConstraintValidatorContext context, String enumName) {
        context.disableDefaultConstraintViolation();
        context.buildConstraintViolationWithTemplate(String.format("value must be formed from codes of enum %s", enumName)).addConstraintViolation();
    }
}

