package com.xforceplus.ultraman.app.wilmar.controller;


/**
 * 运维审计表feign客户端
 *
 * @author ultraman
 * @date 2021-10-18
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.wilmar.entity.DevopsAudit;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "wilmar")
public interface DevopsAuditFeignApi {

  /**
   * 通过id查询运维审计表
   * @param  id
   * @return R
   */
  @GetMapping("/devopsAudit/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增运维审计表
   * @param devopsAudit 运维审计表
   * @return R
   */
  @PostMapping("/devopsAudit/add")
  public R save(@RequestBody DevopsAudit devopsAudit);

  /**
   * 修改运维审计表
   * @param devopsAudit 运维审计表
   * @return R
   */
  @PostMapping("/devopsAudit/update")
  public R updateById(@RequestBody DevopsAudit devopsAudit);

  /**
   * 通过id删除运维审计表
   * @param  id
   * @return R
   */
  @DeleteMapping("/devopsAudit/del/{id}" )
  public R removeById(@PathVariable Long id);

}