package com.xforceplus.ultraman.app.wilmar.controller;


/**
 * 物料feign客户端
 *
 * @author ultraman
 * @date 2021-10-18
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.wilmar.entity.MaterialDocument;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "wilmar")
public interface MaterialDocumentFeignApi {

  /**
   * 通过id查询物料
   * @param  id
   * @return R
   */
  @GetMapping("/materialDocument/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增物料
   * @param materialDocument 物料
   * @return R
   */
  @PostMapping("/materialDocument/add")
  public R save(@RequestBody MaterialDocument materialDocument);

  /**
   * 修改物料
   * @param materialDocument 物料
   * @return R
   */
  @PostMapping("/materialDocument/update")
  public R updateById(@RequestBody MaterialDocument materialDocument);

  /**
   * 通过id删除物料
   * @param  id
   * @return R
   */
  @DeleteMapping("/materialDocument/del/{id}" )
  public R removeById(@PathVariable Long id);

}