package com.xforceplus.ultraman.app.wilmarma.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * bill_doc_type
 * </p>
 *
 * @author ultraman
 * @since 2024-03-15
 */
public enum BillDocType {

    SETTLEMENT("Settlement", "对账收退货结算"),
    DISCOUNT("Discount", "对账折让"),
    PAYMENT("Payment", "回款发票"),
    DEBIT("Debit", "回款账扣");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    BillDocType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static BillDocType fromCode(String code){
        switch(code) {
            case "Settlement":
                return SETTLEMENT;
            case "Discount":
                return DISCOUNT;
            case "Payment":
                return PAYMENT;
            case "Debit":
                return DEBIT;
            default:
                return null;
        }
    }
}
