package com.xforceplus.ultraman.app.wilmarma.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * erp_transmit_status_type
 * </p>
 *
 * @author ultraman
 * @since 2024-03-15
 */
public enum ErpTransmitStatusType {

    P("P", "未推送"),
    N("N", "不推送"),
    H("H", "无需推送"),
    S("S", "成功"),
    F("F", "失败");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    ErpTransmitStatusType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ErpTransmitStatusType fromCode(String code){
        switch(code) {
            case "P":
                return P;
            case "N":
                return N;
            case "H":
                return H;
            case "S":
                return S;
            case "F":
                return F;
            default:
                return null;
        }
    }
}
