package com.xforceplus.ultraman.app.wilmarma.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 对账回款-折让费用
 * </p>
 *
 * @author ultraman
 * @since 2024-03-15
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class Dzzrfy implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 集团/系统
   */
  private String group;

  /**
   * 所属分公司
   */
  private String gsdm;

  /**
   * 所属分公司名称
   */
  private String gsmc;

  /**
   * 门店
   */
  private String mdmc;

  /**
   * 售达方（SAP)
   */
  private String sudf;

  /**
   * 送达方（SAP)
   */
  private String sodf;

  /**
   * 结算单号
   */
  private String djbh;

  /**
   * 零售商编码
   */
  @TableField("purchaseRetailerId")
  private String purchaseRetailerId;

  /**
   * 零售商描述
   */
  @TableField("purchaseRetailerName")
  private String purchaseRetailerName;

  /**
   * 费用单号
   */
  private String fydh;

  /**
   * 费用名称
   */
  private String fymc;

  /**
   * 税率
   */
  private String sl;

  /**
   * 扣点
   */
  private BigDecimal kd;

  /**
   * 未税未含扣点金额
   */
  private BigDecimal zqws;

  /**
   * 未税含扣点金额
   */
  private BigDecimal zhws;

  /**
   * 含税未扣点金额
   */
  private BigDecimal zqhs;

  /**
   * 含税含扣点金额
   */
  private BigDecimal zhhs;

  /**
   * 抓取账号
   */
  private String zqzh;

  /**
   * 更新标记
   */
  private String gxbj;

  /**
   * UUID
   */
  private String uuid;

  /**
   * 网站删除标记
   */
  private String dele;

  /**
   * 是否手工上传
   */
  private String scbj;

  /**
   * 备注
   */
  private String bz;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * SAP传输状态
   */
  @TableField("erpTransmitStatus")
  private String erpTransmitStatus;

  /**
   * SAP传输批次号
   */
  @TableField("batchNumber")
  private String batchNumber;

  /**
   * 主键
   */
  @TableField("businessId")
  private String businessId;

  /**
   * 是否删除
   */
  @TableField("deleteOrNot")
  private String deleteOrNot;

  /**
   * 费用明细版本号
   */
  @TableField("expenseVersion")
  private String expenseVersion;

  /**
   * 销售组织
   */
  @TableField("salesOrg")
  private String salesOrg;

  /**
   * 错误信息
   */
  @TableField("errorMessage")
  private String errorMessage;

  /**
   * 采集时间
   */
  @TableField("collectTime")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime collectTime;

  /**
   * 销售组织名称
   */
  @TableField("salesOrgName")
  private String salesOrgName;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("group", group);
      map.put("gsdm", gsdm);
      map.put("gsmc", gsmc);
      map.put("mdmc", mdmc);
      map.put("sudf", sudf);
      map.put("sodf", sodf);
      map.put("djbh", djbh);
      map.put("purchaseRetailerId", purchaseRetailerId);
      map.put("purchaseRetailerName", purchaseRetailerName);
      map.put("fydh", fydh);
      map.put("fymc", fymc);
      map.put("sl", sl);
      map.put("kd", kd);
      map.put("zqws", zqws);
      map.put("zhws", zhws);
      map.put("zqhs", zqhs);
      map.put("zhhs", zhhs);
      map.put("zqzh", zqzh);
      map.put("gxbj", gxbj);
      map.put("uuid", uuid);
      map.put("dele", dele);
      map.put("scbj", scbj);
      map.put("bz", bz);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("erpTransmitStatus", erpTransmitStatus);
      map.put("batchNumber", batchNumber);
      map.put("businessId", businessId);
      map.put("deleteOrNot", deleteOrNot);
      map.put("expenseVersion", expenseVersion);
      map.put("salesOrg", salesOrg);
      map.put("errorMessage", errorMessage);
      map.put("collectTime", BocpGenUtils.toTimestamp(collectTime));
      map.put("salesOrgName", salesOrgName);

      return map;
  }

  public static Dzzrfy fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    Dzzrfy entity = new Dzzrfy();
    if(map.containsKey("group")) {
      Object obj = map.get("group");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setGroup((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("gsdm")) {
      Object obj = map.get("gsdm");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setGsdm((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("gsmc")) {
      Object obj = map.get("gsmc");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setGsmc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("mdmc")) {
      Object obj = map.get("mdmc");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setMdmc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sudf")) {
      Object obj = map.get("sudf");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSudf((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sodf")) {
      Object obj = map.get("sodf");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSodf((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("djbh")) {
      Object obj = map.get("djbh");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDjbh((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseRetailerId")) {
      Object obj = map.get("purchaseRetailerId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseRetailerId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseRetailerName")) {
      Object obj = map.get("purchaseRetailerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseRetailerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("fydh")) {
      Object obj = map.get("fydh");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setFydh((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("fymc")) {
      Object obj = map.get("fymc");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setFymc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sl")) {
      Object obj = map.get("sl");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSl((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("kd")) {
      Object obj = map.get("kd");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setKd((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setKd(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setKd(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setKd(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setKd(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("zqws")) {
      Object obj = map.get("zqws");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setZqws((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setZqws(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setZqws(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setZqws(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setZqws(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("zhws")) {
      Object obj = map.get("zhws");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setZhws((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setZhws(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setZhws(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setZhws(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setZhws(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("zqhs")) {
      Object obj = map.get("zqhs");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setZqhs((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setZqhs(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setZqhs(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setZqhs(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setZqhs(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("zhhs")) {
      Object obj = map.get("zhhs");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setZhhs((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setZhhs(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setZhhs(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setZhhs(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setZhhs(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("zqzh")) {
      Object obj = map.get("zqzh");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setZqzh((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("gxbj")) {
      Object obj = map.get("gxbj");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setGxbj((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("uuid")) {
      Object obj = map.get("uuid");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUuid((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("dele")) {
      Object obj = map.get("dele");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDele((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("scbj")) {
      Object obj = map.get("scbj");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setScbj((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bz")) {
      Object obj = map.get("bz");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBz((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("erpTransmitStatus")) {
      Object obj = map.get("erpTransmitStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setErpTransmitStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("batchNumber")) {
      Object obj = map.get("batchNumber");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBatchNumber((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("businessId")) {
      Object obj = map.get("businessId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBusinessId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("deleteOrNot")) {
      Object obj = map.get("deleteOrNot");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteOrNot((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("expenseVersion")) {
      Object obj = map.get("expenseVersion");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExpenseVersion((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("salesOrg")) {
      Object obj = map.get("salesOrg");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSalesOrg((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("errorMessage")) {
      Object obj = map.get("errorMessage");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setErrorMessage((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("collectTime")) {
      Object obj = map.get("collectTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCollectTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCollectTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCollectTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCollectTime(null);
      }
    }
    if(map.containsKey("salesOrgName")) {
      Object obj = map.get("salesOrgName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSalesOrgName((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("group")) {
      Object obj = map.get("group");
      if(obj != null) {
        if(obj instanceof String) {
          this.setGroup((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("gsdm")) {
      Object obj = map.get("gsdm");
      if(obj != null) {
        if(obj instanceof String) {
          this.setGsdm((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("gsmc")) {
      Object obj = map.get("gsmc");
      if(obj != null) {
        if(obj instanceof String) {
          this.setGsmc((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("mdmc")) {
      Object obj = map.get("mdmc");
      if(obj != null) {
        if(obj instanceof String) {
          this.setMdmc((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sudf")) {
      Object obj = map.get("sudf");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSudf((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sodf")) {
      Object obj = map.get("sodf");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSodf((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("djbh")) {
      Object obj = map.get("djbh");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDjbh((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaseRetailerId")) {
      Object obj = map.get("purchaseRetailerId");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaseRetailerId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaseRetailerName")) {
      Object obj = map.get("purchaseRetailerName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaseRetailerName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("fydh")) {
      Object obj = map.get("fydh");
      if(obj != null) {
        if(obj instanceof String) {
          this.setFydh((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("fymc")) {
      Object obj = map.get("fymc");
      if(obj != null) {
        if(obj instanceof String) {
          this.setFymc((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sl")) {
      Object obj = map.get("sl");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSl((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("kd")) {
      Object obj = map.get("kd");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setKd((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setKd(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setKd(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setKd(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setKd(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("zqws")) {
      Object obj = map.get("zqws");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setZqws((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setZqws(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setZqws(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setZqws(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setZqws(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("zhws")) {
      Object obj = map.get("zhws");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setZhws((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setZhws(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setZhws(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setZhws(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setZhws(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("zqhs")) {
      Object obj = map.get("zqhs");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setZqhs((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setZqhs(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setZqhs(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setZqhs(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setZqhs(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("zhhs")) {
      Object obj = map.get("zhhs");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setZhhs((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setZhhs(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setZhhs(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setZhhs(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setZhhs(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("zqzh")) {
      Object obj = map.get("zqzh");
      if(obj != null) {
        if(obj instanceof String) {
          this.setZqzh((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("gxbj")) {
      Object obj = map.get("gxbj");
      if(obj != null) {
        if(obj instanceof String) {
          this.setGxbj((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("uuid")) {
      Object obj = map.get("uuid");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUuid((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("dele")) {
      Object obj = map.get("dele");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDele((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("scbj")) {
      Object obj = map.get("scbj");
      if(obj != null) {
        if(obj instanceof String) {
          this.setScbj((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("bz")) {
      Object obj = map.get("bz");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBz((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("erpTransmitStatus")) {
      Object obj = map.get("erpTransmitStatus");
      if(obj != null) {
        if(obj instanceof String) {
          this.setErpTransmitStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("batchNumber")) {
      Object obj = map.get("batchNumber");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBatchNumber((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("businessId")) {
      Object obj = map.get("businessId");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBusinessId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("deleteOrNot")) {
      Object obj = map.get("deleteOrNot");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteOrNot((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("expenseVersion")) {
      Object obj = map.get("expenseVersion");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExpenseVersion((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("salesOrg")) {
      Object obj = map.get("salesOrg");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSalesOrg((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("errorMessage")) {
      Object obj = map.get("errorMessage");
      if(obj != null) {
        if(obj instanceof String) {
          this.setErrorMessage((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("collectTime")) {
      Object obj = map.get("collectTime");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCollectTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCollectTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCollectTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCollectTime(null);
      }
    }
    if(map.containsKey("salesOrgName")) {
      Object obj = map.get("salesOrgName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSalesOrgName((String)obj);
        }
      } else {
      }
    }
  }
}
