package com.xforceplus.ultraman.app.wilmarma.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * bill_doc_type
 * </p>
 *
 * @author ultraman
 * @since 2024-06-13
 */
public enum BillDocType {

    SETTLEMENT("Settlement", "对账收退货结算"),
    DISCOUNT("Discount", "对账折让"),
    PAYMENT("Payment", "回款发票"),
    DEBIT("Debit", "回款账扣");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    BillDocType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static BillDocType fromCode(String code) {
        return Stream.of(BillDocType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
