package com.xforceplus.ultraman.app.wilmarma.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * dele_type
 * </p>
 *
 * @author ultraman
 * @since 2024-06-13
 */
public enum DeleType {

    Y("Y", "删除"),
    N("N", "非删除");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    DeleType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static DeleType fromCode(String code) {
        return Stream.of(DeleType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
