package com.xforceplus.ultraman.app.wilmarma.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * delete_or_not_type
 * </p>
 *
 * @author ultraman
 * @since 2024-06-13
 */
public enum DeleteOrNotType {

    Y("Y", "是"),
    N("N", "否");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    DeleteOrNotType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static DeleteOrNotType fromCode(String code) {
        return Stream.of(DeleteOrNotType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
