package com.xforceplus.ultraman.app.wilmarma.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * erp_transmit_status_type
 * </p>
 *
 * @author ultraman
 * @since 2024-06-13
 */
public enum ErpTransmitStatusType {

    P("P", "未推送"),
    N("N", "不推送"),
    H("H", "无需推送"),
    S("S", "成功"),
    F("F", "失败");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    ErpTransmitStatusType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ErpTransmitStatusType fromCode(String code) {
        return Stream.of(ErpTransmitStatusType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
