package com.xforceplus.ultraman.app.wilmarma.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * order_push_status_type
 * </p>
 *
 * @author ultraman
 * @since 2024-06-13
 */
public enum OrderPushStatusType {

    _0("0", "不可推送"),
    _1("1", "待推送"),
    _2("2", "已推送"),
    _3("3", "推送失败");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    OrderPushStatusType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static OrderPushStatusType fromCode(String code) {
        return Stream.of(OrderPushStatusType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
