package com.xforceplus.ultraman.app.wilmarma.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * partners_type
 * </p>
 *
 * @author ultraman
 * @since 2024-06-13
 */
public enum PartnersType {

    _1("1", "售达方"),
    _2("2", "送达方"),
    _3("3", "付款方"),
    _4("4", "开票方");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    PartnersType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static PartnersType fromCode(String code) {
        return Stream.of(PartnersType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
