package com.xforceplus.ultraman.app.wilmarma.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * update_type
 * </p>
 *
 * @author ultraman
 * @since 2024-06-13
 */
public enum UpdateType {

    Y("Y", "有更新"),
    N("N", "无更新");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    UpdateType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static UpdateType fromCode(String code) {
        return Stream.of(UpdateType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
