package com.xforceplus.ultraman.app.wilmarma.metadata.entity;

import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * hkfp
 * </p>
 *
 * @author ultraman
 * @since 2024-06-13
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class Hkfp implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;
  /**
   * 集团/系统
   */
  private String group;
  /**
   * 所属分公司
   */
  private String gsdm;
  /**
   * 所属分公司名称
   */
  private String gsmc;
  /**
   * 门店（卖场）
   */
  private String mdmc;
  /**
   * 售达方（SAP)
   */
  private String sudf;
  /**
   * 送达方
   */
  private String sodf;
  /**
   * 单据编号
   */
  private String djbh;
  /**
   * 付款日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime fkrq;
  /**
   * 付款总金额
   */
  private BigDecimal fkzje;
  /**
   * 发票号
   */
  private String fph;
  /**
   * 发票日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime fprq;
  /**
   * 发票金额
   */
  private BigDecimal fpje;
  /**
   * 备注
   */
  private String bz;
  /**
   * 抓取账号
   */
  private String zqzh;
  /**
   * 计划付款日
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime jhfkr;
  /**
   * 付款编号
   */
  private String fkbh;
  /**
   * SAP no
   */
  private String sapno;
  /**
   * 供应商编号
   */
  private String gysbh;
  /**
   * 更新标记
   */
  private String gxbj;
  /**
   * UUID
   */
  private String uuid;
  /**
   * 网站删除标记
   */
  private String dele;
  /**
   * 是否手工上传
   */
  private String scbj;
  /**
   * id
   */
  private Long id;
  /**
   * 租户ID
   */
  private Long tenantId;
  /**
   * 租户代码
   */
  private String tenantCode;
  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;
  /**
   * 修改时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;
  /**
   * 创建人ID
   */
  private Long createUserId;
  /**
   * 修改人ID
   */
  private Long updateUserId;
  /**
   * 创建人名字
   */
  private String createUserName;
  /**
   * 修改人名字
   */
  private String updateUserName;
  /**
   * 删除标记
   */
  private String deleteFlag;
  /**
   * 零售商编码
   */
  private String purchaseRetailerId;
  /**
   * 零售商描述
   */
  private String purchaseRetailerName;
  /**
   * SAP传输状态
   */
  private String erpTransmitStatus;
  /**
   * SAP传输批次号
   */
  private String batchNumber;
  /**
   * 是否删除
   */
  private String deleteOrNot;
  /**
   * 付款单版本号
   */
  private String paymentVersion;
  /**
   * 错误信息
   */
  private String errorMessage;
  /**
   * 销售组织
   */
  private String salesOrg;
  /**
   * 采集时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime collectTime;
  /**
   * 主键
   */
  private String businessId;
  /**
   * 销售组织名称
   */
  private String salesOrgName;


  public Map toOQSMap() {
      Map map = new HashMap();
      map.put("group", group);
      map.put("gsdm", gsdm);
      map.put("gsmc", gsmc);
      map.put("mdmc", mdmc);
      map.put("sudf", sudf);
      map.put("sodf", sodf);
      map.put("djbh", djbh);
      map.put("fkrq", BocpGenUtils.toTimestamp(fkrq));
      map.put("fkzje", fkzje);
      map.put("fph", fph);
      map.put("fprq", BocpGenUtils.toTimestamp(fprq));
      map.put("fpje", fpje);
      map.put("bz", bz);
      map.put("zqzh", zqzh);
      map.put("jhfkr", BocpGenUtils.toTimestamp(jhfkr));
      map.put("fkbh", fkbh);
      map.put("sapno", sapno);
      map.put("gysbh", gysbh);
      map.put("gxbj", gxbj);
      map.put("uuid", uuid);
      map.put("dele", dele);
      map.put("scbj", scbj);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("purchaseRetailerId", purchaseRetailerId);
      map.put("purchaseRetailerName", purchaseRetailerName);
      map.put("erpTransmitStatus", erpTransmitStatus);
      map.put("batchNumber", batchNumber);
      map.put("deleteOrNot", deleteOrNot);
      map.put("paymentVersion", paymentVersion);
      map.put("errorMessage", errorMessage);
      map.put("salesOrg", salesOrg);
      map.put("collectTime", BocpGenUtils.toTimestamp(collectTime));
      map.put("businessId", businessId);
      map.put("salesOrgName", salesOrgName);

      return map;
  }

  public static Hkfp fromOQSMap(Map map) {
    if(map == null || map.isEmpty()) {
      return null;
    }
    Hkfp entity = new Hkfp();

    if(map.containsKey("group")) {
      Object obj = map.get("group");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setGroup((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("gsdm")) {
      Object obj = map.get("gsdm");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setGsdm((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("gsmc")) {
      Object obj = map.get("gsmc");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setGsmc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("mdmc")) {
      Object obj = map.get("mdmc");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setMdmc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sudf")) {
      Object obj = map.get("sudf");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSudf((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sodf")) {
      Object obj = map.get("sodf");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSodf((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("djbh")) {
      Object obj = map.get("djbh");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDjbh((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("fkrq")) {
      Object obj = map.get("fkrq");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setFkrq(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setFkrq((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setFkrq(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setFkrq(null);
      }
    }
    if(map.containsKey("fkzje")) {
      Object obj = map.get("fkzje");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setFkzje((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setFkzje(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setFkzje(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setFkzje(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setFkzje(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("fph")) {
      Object obj = map.get("fph");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setFph((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("fprq")) {
      Object obj = map.get("fprq");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setFprq(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setFprq((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setFprq(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setFprq(null);
      }
    }
    if(map.containsKey("fpje")) {
      Object obj = map.get("fpje");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setFpje((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setFpje(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setFpje(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setFpje(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setFpje(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("bz")) {
      Object obj = map.get("bz");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBz((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("zqzh")) {
      Object obj = map.get("zqzh");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setZqzh((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("jhfkr")) {
      Object obj = map.get("jhfkr");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setJhfkr(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setJhfkr((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setJhfkr(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setJhfkr(null);
      }
    }
    if(map.containsKey("fkbh")) {
      Object obj = map.get("fkbh");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setFkbh((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sapno")) {
      Object obj = map.get("sapno");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSapno((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("gysbh")) {
      Object obj = map.get("gysbh");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setGysbh((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("gxbj")) {
      Object obj = map.get("gxbj");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setGxbj((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("uuid")) {
      Object obj = map.get("uuid");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUuid((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("dele")) {
      Object obj = map.get("dele");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDele((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("scbj")) {
      Object obj = map.get("scbj");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setScbj((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseRetailerId")) {
      Object obj = map.get("purchaseRetailerId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseRetailerId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseRetailerName")) {
      Object obj = map.get("purchaseRetailerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseRetailerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("erpTransmitStatus")) {
      Object obj = map.get("erpTransmitStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setErpTransmitStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("batchNumber")) {
      Object obj = map.get("batchNumber");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBatchNumber((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("deleteOrNot")) {
      Object obj = map.get("deleteOrNot");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteOrNot((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paymentVersion")) {
      Object obj = map.get("paymentVersion");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPaymentVersion((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("errorMessage")) {
      Object obj = map.get("errorMessage");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setErrorMessage((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("salesOrg")) {
      Object obj = map.get("salesOrg");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSalesOrg((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("collectTime")) {
      Object obj = map.get("collectTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCollectTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCollectTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCollectTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCollectTime(null);
      }
    }
    if(map.containsKey("businessId")) {
      Object obj = map.get("businessId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBusinessId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("salesOrgName")) {
      Object obj = map.get("salesOrgName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSalesOrgName((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("group")) {
      Object obj = map.get("group");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setGroup((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("gsdm")) {
      Object obj = map.get("gsdm");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setGsdm((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("gsmc")) {
      Object obj = map.get("gsmc");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setGsmc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("mdmc")) {
      Object obj = map.get("mdmc");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setMdmc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sudf")) {
      Object obj = map.get("sudf");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSudf((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sodf")) {
      Object obj = map.get("sodf");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSodf((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("djbh")) {
      Object obj = map.get("djbh");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDjbh((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("fkrq")) {
      Object obj = map.get("fkrq");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setFkrq(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setFkrq((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setFkrq(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setFkrq(null);
      }
    }
    if(map.containsKey("fkzje")) {
      Object obj = map.get("fkzje");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setFkzje((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setFkzje(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setFkzje(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setFkzje(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setFkzje(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("fph")) {
      Object obj = map.get("fph");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setFph((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("fprq")) {
      Object obj = map.get("fprq");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setFprq(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setFprq((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setFprq(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setFprq(null);
      }
    }
    if(map.containsKey("fpje")) {
      Object obj = map.get("fpje");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setFpje((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setFpje(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setFpje(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setFpje(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setFpje(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("bz")) {
      Object obj = map.get("bz");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBz((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("zqzh")) {
      Object obj = map.get("zqzh");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setZqzh((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("jhfkr")) {
      Object obj = map.get("jhfkr");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setJhfkr(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setJhfkr((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setJhfkr(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setJhfkr(null);
      }
    }
    if(map.containsKey("fkbh")) {
      Object obj = map.get("fkbh");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setFkbh((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sapno")) {
      Object obj = map.get("sapno");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSapno((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("gysbh")) {
      Object obj = map.get("gysbh");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setGysbh((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("gxbj")) {
      Object obj = map.get("gxbj");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setGxbj((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("uuid")) {
      Object obj = map.get("uuid");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setUuid((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("dele")) {
      Object obj = map.get("dele");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDele((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("scbj")) {
      Object obj = map.get("scbj");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setScbj((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseRetailerId")) {
      Object obj = map.get("purchaseRetailerId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPurchaseRetailerId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseRetailerName")) {
      Object obj = map.get("purchaseRetailerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPurchaseRetailerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("erpTransmitStatus")) {
      Object obj = map.get("erpTransmitStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setErpTransmitStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("batchNumber")) {
      Object obj = map.get("batchNumber");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBatchNumber((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("deleteOrNot")) {
      Object obj = map.get("deleteOrNot");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDeleteOrNot((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paymentVersion")) {
      Object obj = map.get("paymentVersion");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPaymentVersion((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("errorMessage")) {
      Object obj = map.get("errorMessage");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setErrorMessage((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("salesOrg")) {
      Object obj = map.get("salesOrg");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSalesOrg((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("collectTime")) {
      Object obj = map.get("collectTime");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCollectTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCollectTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCollectTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCollectTime(null);
      }
    }
    if(map.containsKey("businessId")) {
      Object obj = map.get("businessId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBusinessId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("salesOrgName")) {
      Object obj = map.get("salesOrgName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSalesOrgName((String)obj);
        }
      } else{
      }
    }
  }
}
