package com.xforceplus.ultraman.app.wilmarma.metadata.entity;

import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * mara
 * </p>
 *
 * @author ultraman
 * @since 2024-06-13
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class Mara implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;
  /**
   * 主键ID
   */
  private String materialid;
  /**
   * 物料号
   */
  private String matnr;
  /**
   * 创建日期
   */
  private String ersda;
  /**
   * 创建对象的人员名称
   */
  private String ernam;
  /**
   * 在客户级标记要删除的物料
   */
  private String lvorm;
  /**
   * 物料类型
   */
  private String mtart;
  /**
   * 物料类型名称
   */
  private String mtbez;
  /**
   * 行业领域
   */
  private String mbrsh;
  /**
   * 普通项目类别组
   */
  private String mtposMara;
  /**
   * 物料组
   */
  private String matkl;
  /**
   * 旧物料号
   */
  private String bismt;
  /**
   * 基本计量单位
   */
  private String meins;
  /**
   * 采购订单的计量单位
   */
  private String bstme;
  /**
   * 大小/量纲
   */
  private String groes;
  /**
   * 基本物料
   */
  private String wrkst;
  /**
   * 行业标准描述（例如 ANSI 或 ISO）
   */
  private String normt;
  /**
   * 毛重
   */
  private String brgew;
  /**
   * 净重
   */
  private String ntgew;
  /**
   * 重量单位
   */
  private String gewei;
  /**
   * 体积
   */
  private String volum;
  /**
   * 体积单位
   */
  private String voleh;
  /**
   * 容器需求
   */
  private String behvo;
  /**
   * 存储条件
   */
  private String raube;
  /**
   * 温度条件标识
   */
  private String tempb;
  /**
   * 低层代码
   */
  private String disst;
  /**
   * 运输组
   */
  private String tragr;
  /**
   * 危险物料号
   */
  private String stoff;
  /**
   * 产品组
   */
  private String spart;
  /**
   * 长度
   */
  private String laeng;
  /**
   * 宽度
   */
  private String breit;
  /**
   * 高度
   */
  private String hoehe;
  /**
   * 长度/宽度/高度的尺寸单位
   */
  private String meabm;
  /**
   * 大类编号
   */
  private String dalei;
  /**
   * 大类编号名称
   */
  private String datxt;
  /**
   * 中类编号
   */
  private String xilei;
  /**
   * 中类编号名称
   */
  private String xicht;
  /**
   * 小类编号
   */
  private String xxlei;
  /**
   * 小类编号名称
   */
  private String xxtxt;
  /**
   * 超小类编号
   */
  private String xxlei2;
  /**
   * 超小类编号名称
   */
  private String xxtxt2;
  /**
   * 品牌
   */
  private String pinpa;
  /**
   * 规格
   */
  private String guig;
  /**
   * 规格名称
   */
  private String zhonl;
  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createdate;
  /**
   * 修改时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updatedate;
  /**
   * id
   */
  private Long id;
  /**
   * 租户ID
   */
  private Long tenantId;
  /**
   * 租户代码
   */
  private String tenantCode;
  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;
  /**
   * 修改时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;
  /**
   * 创建人ID
   */
  private Long createUserId;
  /**
   * 修改人ID
   */
  private Long updateUserId;
  /**
   * 创建人名字
   */
  private String createUserName;
  /**
   * 修改人名字
   */
  private String updateUserName;
  /**
   * 删除标记
   */
  private String deleteFlag;


  public Map toOQSMap() {
      Map map = new HashMap();
      map.put("materialid", materialid);
      map.put("matnr", matnr);
      map.put("ersda", ersda);
      map.put("ernam", ernam);
      map.put("lvorm", lvorm);
      map.put("mtart", mtart);
      map.put("mtbez", mtbez);
      map.put("mbrsh", mbrsh);
      map.put("mtpos_mara", mtposMara);
      map.put("matkl", matkl);
      map.put("bismt", bismt);
      map.put("meins", meins);
      map.put("bstme", bstme);
      map.put("groes", groes);
      map.put("wrkst", wrkst);
      map.put("normt", normt);
      map.put("brgew", brgew);
      map.put("ntgew", ntgew);
      map.put("gewei", gewei);
      map.put("volum", volum);
      map.put("voleh", voleh);
      map.put("behvo", behvo);
      map.put("raube", raube);
      map.put("tempb", tempb);
      map.put("disst", disst);
      map.put("tragr", tragr);
      map.put("stoff", stoff);
      map.put("spart", spart);
      map.put("laeng", laeng);
      map.put("breit", breit);
      map.put("hoehe", hoehe);
      map.put("meabm", meabm);
      map.put("dalei", dalei);
      map.put("datxt", datxt);
      map.put("xilei", xilei);
      map.put("xicht", xicht);
      map.put("xxlei", xxlei);
      map.put("xxtxt", xxtxt);
      map.put("xxlei2", xxlei2);
      map.put("xxtxt2", xxtxt2);
      map.put("pinpa", pinpa);
      map.put("guig", guig);
      map.put("zhonl", zhonl);
      map.put("createdate", BocpGenUtils.toTimestamp(createdate));
      map.put("updatedate", BocpGenUtils.toTimestamp(updatedate));
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);

      return map;
  }

  public static Mara fromOQSMap(Map map) {
    if(map == null || map.isEmpty()) {
      return null;
    }
    Mara entity = new Mara();

    if(map.containsKey("materialid")) {
      Object obj = map.get("materialid");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setMaterialid((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("matnr")) {
      Object obj = map.get("matnr");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setMatnr((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ersda")) {
      Object obj = map.get("ersda");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setErsda((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ernam")) {
      Object obj = map.get("ernam");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setErnam((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("lvorm")) {
      Object obj = map.get("lvorm");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setLvorm((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("mtart")) {
      Object obj = map.get("mtart");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setMtart((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("mtbez")) {
      Object obj = map.get("mtbez");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setMtbez((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("mbrsh")) {
      Object obj = map.get("mbrsh");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setMbrsh((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("mtpos_mara")) {
      Object obj = map.get("mtpos_mara");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setMtposMara((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("matkl")) {
      Object obj = map.get("matkl");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setMatkl((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bismt")) {
      Object obj = map.get("bismt");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBismt((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("meins")) {
      Object obj = map.get("meins");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setMeins((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bstme")) {
      Object obj = map.get("bstme");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBstme((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("groes")) {
      Object obj = map.get("groes");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setGroes((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("wrkst")) {
      Object obj = map.get("wrkst");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setWrkst((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("normt")) {
      Object obj = map.get("normt");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setNormt((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("brgew")) {
      Object obj = map.get("brgew");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBrgew((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ntgew")) {
      Object obj = map.get("ntgew");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setNtgew((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("gewei")) {
      Object obj = map.get("gewei");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setGewei((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("volum")) {
      Object obj = map.get("volum");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setVolum((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("voleh")) {
      Object obj = map.get("voleh");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setVoleh((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("behvo")) {
      Object obj = map.get("behvo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBehvo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("raube")) {
      Object obj = map.get("raube");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRaube((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tempb")) {
      Object obj = map.get("tempb");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTempb((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("disst")) {
      Object obj = map.get("disst");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDisst((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tragr")) {
      Object obj = map.get("tragr");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTragr((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("stoff")) {
      Object obj = map.get("stoff");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setStoff((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("spart")) {
      Object obj = map.get("spart");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSpart((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("laeng")) {
      Object obj = map.get("laeng");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setLaeng((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("breit")) {
      Object obj = map.get("breit");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBreit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("hoehe")) {
      Object obj = map.get("hoehe");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setHoehe((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("meabm")) {
      Object obj = map.get("meabm");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setMeabm((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("dalei")) {
      Object obj = map.get("dalei");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDalei((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("datxt")) {
      Object obj = map.get("datxt");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDatxt((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("xilei")) {
      Object obj = map.get("xilei");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setXilei((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("xicht")) {
      Object obj = map.get("xicht");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setXicht((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("xxlei")) {
      Object obj = map.get("xxlei");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setXxlei((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("xxtxt")) {
      Object obj = map.get("xxtxt");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setXxtxt((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("xxlei2")) {
      Object obj = map.get("xxlei2");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setXxlei2((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("xxtxt2")) {
      Object obj = map.get("xxtxt2");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setXxtxt2((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pinpa")) {
      Object obj = map.get("pinpa");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPinpa((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("guig")) {
      Object obj = map.get("guig");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setGuig((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("zhonl")) {
      Object obj = map.get("zhonl");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setZhonl((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("createdate")) {
      Object obj = map.get("createdate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreatedate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreatedate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreatedate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreatedate(null);
      }
    }
    if(map.containsKey("updatedate")) {
      Object obj = map.get("updatedate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdatedate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdatedate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdatedate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdatedate(null);
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("materialid")) {
      Object obj = map.get("materialid");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setMaterialid((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("matnr")) {
      Object obj = map.get("matnr");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setMatnr((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ersda")) {
      Object obj = map.get("ersda");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setErsda((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ernam")) {
      Object obj = map.get("ernam");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setErnam((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("lvorm")) {
      Object obj = map.get("lvorm");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setLvorm((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("mtart")) {
      Object obj = map.get("mtart");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setMtart((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("mtbez")) {
      Object obj = map.get("mtbez");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setMtbez((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("mbrsh")) {
      Object obj = map.get("mbrsh");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setMbrsh((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("mtpos_mara")) {
      Object obj = map.get("mtpos_mara");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setMtposMara((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("matkl")) {
      Object obj = map.get("matkl");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setMatkl((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bismt")) {
      Object obj = map.get("bismt");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBismt((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("meins")) {
      Object obj = map.get("meins");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setMeins((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bstme")) {
      Object obj = map.get("bstme");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBstme((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("groes")) {
      Object obj = map.get("groes");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setGroes((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("wrkst")) {
      Object obj = map.get("wrkst");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setWrkst((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("normt")) {
      Object obj = map.get("normt");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setNormt((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("brgew")) {
      Object obj = map.get("brgew");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBrgew((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ntgew")) {
      Object obj = map.get("ntgew");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setNtgew((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("gewei")) {
      Object obj = map.get("gewei");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setGewei((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("volum")) {
      Object obj = map.get("volum");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setVolum((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("voleh")) {
      Object obj = map.get("voleh");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setVoleh((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("behvo")) {
      Object obj = map.get("behvo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBehvo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("raube")) {
      Object obj = map.get("raube");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setRaube((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tempb")) {
      Object obj = map.get("tempb");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTempb((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("disst")) {
      Object obj = map.get("disst");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDisst((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tragr")) {
      Object obj = map.get("tragr");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTragr((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("stoff")) {
      Object obj = map.get("stoff");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setStoff((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("spart")) {
      Object obj = map.get("spart");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSpart((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("laeng")) {
      Object obj = map.get("laeng");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setLaeng((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("breit")) {
      Object obj = map.get("breit");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBreit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("hoehe")) {
      Object obj = map.get("hoehe");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setHoehe((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("meabm")) {
      Object obj = map.get("meabm");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setMeabm((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("dalei")) {
      Object obj = map.get("dalei");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDalei((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("datxt")) {
      Object obj = map.get("datxt");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDatxt((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("xilei")) {
      Object obj = map.get("xilei");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setXilei((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("xicht")) {
      Object obj = map.get("xicht");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setXicht((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("xxlei")) {
      Object obj = map.get("xxlei");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setXxlei((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("xxtxt")) {
      Object obj = map.get("xxtxt");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setXxtxt((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("xxlei2")) {
      Object obj = map.get("xxlei2");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setXxlei2((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("xxtxt2")) {
      Object obj = map.get("xxtxt2");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setXxtxt2((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pinpa")) {
      Object obj = map.get("pinpa");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPinpa((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("guig")) {
      Object obj = map.get("guig");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setGuig((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("zhonl")) {
      Object obj = map.get("zhonl");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setZhonl((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("createdate")) {
      Object obj = map.get("createdate");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreatedate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCreatedate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreatedate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCreatedate(null);
      }
    }
    if(map.containsKey("updatedate")) {
      Object obj = map.get("updatedate");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdatedate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setUpdatedate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdatedate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setUpdatedate(null);
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
  }
}
