package com.xforceplus.ultraman.app.wilmarma.metadata.validator;

import com.xforceplus.ultraman.app.wilmarma.metadata.validator.annotation.CheckUltramanEnum;

import com.xforceplus.ultraman.app.wilmarma.metadata.dict.*;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

/**
 * <p>
 * UltramanEnumConstraintValidator
 * </p>
 *
 * @author ultraman
 * @since 2024-06-13
 */
public class UltramanEnumConstraintValidator implements ConstraintValidator<CheckUltramanEnum, String> {

    private final String MSG_FORMAT = "value must be the code of one of enum %s";

    Class clazz;

    @Override
    public void initialize(CheckUltramanEnum constraintAnnotation) {
        clazz = constraintAnnotation.value();
    }

    @Override
    public boolean isValid(String value, ConstraintValidatorContext context) {
        if(null == value || value.length() == 0) {
            return true;
        }

        boolean isValid = true;

        if(clazz.equals(FlowStatus.class)) {
            isValid = null != FlowStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, FlowStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(SnapshotFormat.class)) {
            isValid = null != SnapshotFormat.fromCode(value);
            if(!isValid) {
                unValidMsg(context, SnapshotFormat.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceType.class)) {
            isValid = null != InvoiceType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, InvoiceType.class.getSimpleName());
            }
        }
        if(clazz.equals(UpdateType.class)) {
            isValid = null != UpdateType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, UpdateType.class.getSimpleName());
            }
        }
        if(clazz.equals(DeleType.class)) {
            isValid = null != DeleType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, DeleType.class.getSimpleName());
            }
        }
        if(clazz.equals(ScbjType.class)) {
            isValid = null != ScbjType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ScbjType.class.getSimpleName());
            }
        }
        if(clazz.equals(ErpTransmitStatusType.class)) {
            isValid = null != ErpTransmitStatusType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ErpTransmitStatusType.class.getSimpleName());
            }
        }
        if(clazz.equals(DeleteOrNotType.class)) {
            isValid = null != DeleteOrNotType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, DeleteOrNotType.class.getSimpleName());
            }
        }
        if(clazz.equals(BillDocType.class)) {
            isValid = null != BillDocType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, BillDocType.class.getSimpleName());
            }
        }
        if(clazz.equals(OrderPushStatusType.class)) {
            isValid = null != OrderPushStatusType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, OrderPushStatusType.class.getSimpleName());
            }
        }
        if(clazz.equals(PartnersType.class)) {
            isValid = null != PartnersType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, PartnersType.class.getSimpleName());
            }
        }

        return isValid;
    }

    private void unValidMsg(ConstraintValidatorContext context, String enumName){
        context.disableDefaultConstraintViolation();
        context.buildConstraintViolationWithTemplate(
                String.format(MSG_FORMAT, enumName))
                .addConstraintViolation();
    }
}
