package com.xforceplus.ultraman.app.wilmarma.metadata.validator;

import com.xforceplus.ultraman.app.wilmarma.metadata.validator.annotation.CheckUltramanEnums;

import com.xforceplus.ultraman.app.wilmarma.metadata.dict.*;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import java.util.Arrays;
import java.util.List;

/**
 * <p>
 * UltramanEnumsConstraintValidator
 * </p>
 *
 * @author ultraman
 * @since 2024-06-13
 */
public class UltramanEnumsConstraintValidator implements ConstraintValidator<CheckUltramanEnums, String> {

    private final String MSG_FORMAT = "value must be formed from codes of enum %s";

    Class clazz;

    @Override
    public void initialize(CheckUltramanEnums constraintAnnotation) {
        clazz = constraintAnnotation.value();
    }

    @Override
    public boolean isValid(String value, ConstraintValidatorContext context) {
        if(null == value || value.length() == 0) {
            return true;
        }

        boolean isValid = true;
        List<String> vals = Arrays.asList(value.split(","));

        if(clazz.equals(FlowStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != FlowStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, FlowStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(SnapshotFormat.class)) {
            isValid = vals.stream()
                    .filter(val -> null != SnapshotFormat.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, SnapshotFormat.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != InvoiceType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, InvoiceType.class.getSimpleName());
            }
        }
        if(clazz.equals(UpdateType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != UpdateType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, UpdateType.class.getSimpleName());
            }
        }
        if(clazz.equals(DeleType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != DeleType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, DeleType.class.getSimpleName());
            }
        }
        if(clazz.equals(ScbjType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ScbjType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ScbjType.class.getSimpleName());
            }
        }
        if(clazz.equals(ErpTransmitStatusType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ErpTransmitStatusType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ErpTransmitStatusType.class.getSimpleName());
            }
        }
        if(clazz.equals(DeleteOrNotType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != DeleteOrNotType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, DeleteOrNotType.class.getSimpleName());
            }
        }
        if(clazz.equals(BillDocType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != BillDocType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, BillDocType.class.getSimpleName());
            }
        }
        if(clazz.equals(OrderPushStatusType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != OrderPushStatusType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, OrderPushStatusType.class.getSimpleName());
            }
        }
        if(clazz.equals(PartnersType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != PartnersType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, PartnersType.class.getSimpleName());
            }
        }

        return isValid;
    }

    private void unValidMsg(ConstraintValidatorContext context, String enumName){
        context.disableDefaultConstraintViolation();
        context.buildConstraintViolationWithTemplate(
                        String.format(MSG_FORMAT, enumName))
                .addConstraintViolation();
    }
}
