package com.xforceplus.ultraman.app.wilmarma.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.wilmarma.entity.Dzstjs;
import com.xforceplus.ultraman.app.wilmarma.service.IDzstjsService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-01-12
 */
@RestController
public class DzstjsController {

  @Autowired
  private IDzstjsService dzstjsServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param dzstjs ${table.comment}
   * @return
   */
  @GetMapping("/dzstjss" )
  public XfR getDzstjss(XfPage page, Dzstjs dzstjs) {
    return XfR.ok(dzstjsServiceImpl.page(page, Wrappers.query(dzstjs)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/dzstjss/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(dzstjsServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param dzstjs ${table.comment}
   * @return XfR
   */
  @PostMapping("/dzstjss")
  public XfR save(@RequestBody Dzstjs dzstjs) {
     return XfR.ok(dzstjsServiceImpl.save(dzstjs));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param dzstjs ${table.comment}
   * @return XfR
   */
  @PutMapping("/dzstjss/{id}")
  public XfR putUpdate(@RequestBody Dzstjs dzstjs,@PathVariable Long id) {
      dzstjs.setId(id);
      return XfR.ok(dzstjsServiceImpl.updateById(dzstjs));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param dzstjs ${table.comment}
   * @return XfR
   */
  @PatchMapping("/dzstjss/{id}")
  public XfR patchUpdate(@RequestBody Dzstjs dzstjs,@PathVariable Long id) {
      Dzstjs updzstjs = dzstjsServiceImpl.getById(id);
      if(updzstjs != null){
        updzstjs = ObjectCopyUtils.copyProperties(dzstjs,updzstjs,true);
      }
      return XfR.ok(dzstjsServiceImpl.updateById(updzstjs));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/dzstjss/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(dzstjsServiceImpl.removeById(id));
  }

  @PostMapping("/dzstjss/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "dzstjs");
     params.put("request", condition);

     return XfR.ok(dzstjsServiceImpl.querys(params));
  }

}
