package com.xforceplus.ultraman.app.wilmarma.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.wilmarma.entity.Dzzrfy;
import com.xforceplus.ultraman.app.wilmarma.service.IDzzrfyService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-01-12
 */
@RestController
public class DzzrfyController {

  @Autowired
  private IDzzrfyService dzzrfyServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param dzzrfy ${table.comment}
   * @return
   */
  @GetMapping("/dzzrfys" )
  public XfR getDzzrfys(XfPage page, Dzzrfy dzzrfy) {
    return XfR.ok(dzzrfyServiceImpl.page(page, Wrappers.query(dzzrfy)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/dzzrfys/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(dzzrfyServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param dzzrfy ${table.comment}
   * @return XfR
   */
  @PostMapping("/dzzrfys")
  public XfR save(@RequestBody Dzzrfy dzzrfy) {
     return XfR.ok(dzzrfyServiceImpl.save(dzzrfy));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param dzzrfy ${table.comment}
   * @return XfR
   */
  @PutMapping("/dzzrfys/{id}")
  public XfR putUpdate(@RequestBody Dzzrfy dzzrfy,@PathVariable Long id) {
      dzzrfy.setId(id);
      return XfR.ok(dzzrfyServiceImpl.updateById(dzzrfy));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param dzzrfy ${table.comment}
   * @return XfR
   */
  @PatchMapping("/dzzrfys/{id}")
  public XfR patchUpdate(@RequestBody Dzzrfy dzzrfy,@PathVariable Long id) {
      Dzzrfy updzzrfy = dzzrfyServiceImpl.getById(id);
      if(updzzrfy != null){
        updzzrfy = ObjectCopyUtils.copyProperties(dzzrfy,updzzrfy,true);
      }
      return XfR.ok(dzzrfyServiceImpl.updateById(updzzrfy));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/dzzrfys/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(dzzrfyServiceImpl.removeById(id));
  }

  @PostMapping("/dzzrfys/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "dzzrfy");
     params.put("request", condition);

     return XfR.ok(dzzrfyServiceImpl.querys(params));
  }

}
