package com.xforceplus.ultraman.app.wilmarma.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.wilmarma.entity.Hkfp;
import com.xforceplus.ultraman.app.wilmarma.service.IHkfpService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 对账回款-发票前端控制器
 *
 * @author ultraman
 * @date 2024-01-12
 */
@RestController
public class HkfpController {

  @Autowired
  private IHkfpService hkfpServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param hkfp 对账回款-发票
   * @return
   */
  @GetMapping("/hkfps" )
  public XfR getHkfps(XfPage page, Hkfp hkfp) {
    return XfR.ok(hkfpServiceImpl.page(page, Wrappers.query(hkfp)));
  }

  /**
   * 通过id查询对账回款-发票
   * @param  id
   * @return XfR
   */
  @GetMapping("/hkfps/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(hkfpServiceImpl.getById(id));
  }

  /**
   * 新增对账回款-发票
   * @param hkfp 对账回款-发票
   * @return XfR
   */
  @PostMapping("/hkfps")
  public XfR save(@RequestBody Hkfp hkfp) {
     return XfR.ok(hkfpServiceImpl.save(hkfp));
  }

  /**
   * 修改-传入修改后的全部数据对账回款-发票
   * @param hkfp 对账回款-发票
   * @return XfR
   */
  @PutMapping("/hkfps/{id}")
  public XfR putUpdate(@RequestBody Hkfp hkfp,@PathVariable Long id) {
      hkfp.setId(id);
      return XfR.ok(hkfpServiceImpl.updateById(hkfp));
  }

  /**
   * 修改-传入修改的数据对账回款-发票
   * @param hkfp 对账回款-发票
   * @return XfR
   */
  @PatchMapping("/hkfps/{id}")
  public XfR patchUpdate(@RequestBody Hkfp hkfp,@PathVariable Long id) {
      Hkfp uphkfp = hkfpServiceImpl.getById(id);
      if(uphkfp != null){
        uphkfp = ObjectCopyUtils.copyProperties(hkfp,uphkfp,true);
      }
      return XfR.ok(hkfpServiceImpl.updateById(uphkfp));
  }

  /**
   * 通过id删除对账回款-发票
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/hkfps/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(hkfpServiceImpl.removeById(id));
  }

  @PostMapping("/hkfps/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "hkfp");
     params.put("request", condition);

     return XfR.ok(hkfpServiceImpl.querys(params));
  }

}
