package com.xforceplus.ultraman.app.wilmarma.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.wilmarma.entity.Hkzk;
import com.xforceplus.ultraman.app.wilmarma.service.IHkzkService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 对账回款-账扣前端控制器
 *
 * @author ultraman
 * @date 2024-01-12
 */
@RestController
public class HkzkController {

  @Autowired
  private IHkzkService hkzkServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param hkzk 对账回款-账扣
   * @return
   */
  @GetMapping("/hkzks" )
  public XfR getHkzks(XfPage page, Hkzk hkzk) {
    return XfR.ok(hkzkServiceImpl.page(page, Wrappers.query(hkzk)));
  }

  /**
   * 通过id查询对账回款-账扣
   * @param  id
   * @return XfR
   */
  @GetMapping("/hkzks/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(hkzkServiceImpl.getById(id));
  }

  /**
   * 新增对账回款-账扣
   * @param hkzk 对账回款-账扣
   * @return XfR
   */
  @PostMapping("/hkzks")
  public XfR save(@RequestBody Hkzk hkzk) {
     return XfR.ok(hkzkServiceImpl.save(hkzk));
  }

  /**
   * 修改-传入修改后的全部数据对账回款-账扣
   * @param hkzk 对账回款-账扣
   * @return XfR
   */
  @PutMapping("/hkzks/{id}")
  public XfR putUpdate(@RequestBody Hkzk hkzk,@PathVariable Long id) {
      hkzk.setId(id);
      return XfR.ok(hkzkServiceImpl.updateById(hkzk));
  }

  /**
   * 修改-传入修改的数据对账回款-账扣
   * @param hkzk 对账回款-账扣
   * @return XfR
   */
  @PatchMapping("/hkzks/{id}")
  public XfR patchUpdate(@RequestBody Hkzk hkzk,@PathVariable Long id) {
      Hkzk uphkzk = hkzkServiceImpl.getById(id);
      if(uphkzk != null){
        uphkzk = ObjectCopyUtils.copyProperties(hkzk,uphkzk,true);
      }
      return XfR.ok(hkzkServiceImpl.updateById(uphkzk));
  }

  /**
   * 通过id删除对账回款-账扣
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/hkzks/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(hkzkServiceImpl.removeById(id));
  }

  @PostMapping("/hkzks/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "hkzk");
     params.put("request", condition);

     return XfR.ok(hkzkServiceImpl.querys(params));
  }

}
