package com.xforceplus.ultraman.app.wilmarma.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.wilmarma.entity.ItKnvp;
import com.xforceplus.ultraman.app.wilmarma.service.IItKnvpService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 客户送达方前端控制器
 *
 * @author ultraman
 * @date 2024-01-12
 */
@RestController
public class ItKnvpController {

  @Autowired
  private IItKnvpService itKnvpServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param itKnvp 客户送达方
   * @return
   */
  @GetMapping("/itknvps" )
  public XfR getItKnvps(XfPage page, ItKnvp itKnvp) {
    return XfR.ok(itKnvpServiceImpl.page(page, Wrappers.query(itKnvp)));
  }

  /**
   * 通过id查询客户送达方
   * @param  id
   * @return XfR
   */
  @GetMapping("/itknvps/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(itKnvpServiceImpl.getById(id));
  }

  /**
   * 新增客户送达方
   * @param itKnvp 客户送达方
   * @return XfR
   */
  @PostMapping("/itknvps")
  public XfR save(@RequestBody ItKnvp itKnvp) {
     return XfR.ok(itKnvpServiceImpl.save(itKnvp));
  }

  /**
   * 修改-传入修改后的全部数据客户送达方
   * @param itKnvp 客户送达方
   * @return XfR
   */
  @PutMapping("/itknvps/{id}")
  public XfR putUpdate(@RequestBody ItKnvp itKnvp,@PathVariable Long id) {
      itKnvp.setId(id);
      return XfR.ok(itKnvpServiceImpl.updateById(itKnvp));
  }

  /**
   * 修改-传入修改的数据客户送达方
   * @param itKnvp 客户送达方
   * @return XfR
   */
  @PatchMapping("/itknvps/{id}")
  public XfR patchUpdate(@RequestBody ItKnvp itKnvp,@PathVariable Long id) {
      ItKnvp upitKnvp = itKnvpServiceImpl.getById(id);
      if(upitKnvp != null){
        upitKnvp = ObjectCopyUtils.copyProperties(itKnvp,upitKnvp,true);
      }
      return XfR.ok(itKnvpServiceImpl.updateById(upitKnvp));
  }

  /**
   * 通过id删除客户送达方
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/itknvps/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(itKnvpServiceImpl.removeById(id));
  }

  @PostMapping("/itknvps/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "it_knvp");
     params.put("request", condition);

     return XfR.ok(itKnvpServiceImpl.querys(params));
  }

}
