package com.xforceplus.ultraman.app.wilmarma.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.wilmarma.entity.ItVkorg;
import com.xforceplus.ultraman.app.wilmarma.service.IItVkorgService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 客户售达方前端控制器
 *
 * @author ultraman
 * @date 2024-01-12
 */
@RestController
public class ItVkorgController {

  @Autowired
  private IItVkorgService itVkorgServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param itVkorg 客户售达方
   * @return
   */
  @GetMapping("/itvkorgs" )
  public XfR getItVkorgs(XfPage page, ItVkorg itVkorg) {
    return XfR.ok(itVkorgServiceImpl.page(page, Wrappers.query(itVkorg)));
  }

  /**
   * 通过id查询客户售达方
   * @param  id
   * @return XfR
   */
  @GetMapping("/itvkorgs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(itVkorgServiceImpl.getById(id));
  }

  /**
   * 新增客户售达方
   * @param itVkorg 客户售达方
   * @return XfR
   */
  @PostMapping("/itvkorgs")
  public XfR save(@RequestBody ItVkorg itVkorg) {
     return XfR.ok(itVkorgServiceImpl.save(itVkorg));
  }

  /**
   * 修改-传入修改后的全部数据客户售达方
   * @param itVkorg 客户售达方
   * @return XfR
   */
  @PutMapping("/itvkorgs/{id}")
  public XfR putUpdate(@RequestBody ItVkorg itVkorg,@PathVariable Long id) {
      itVkorg.setId(id);
      return XfR.ok(itVkorgServiceImpl.updateById(itVkorg));
  }

  /**
   * 修改-传入修改的数据客户售达方
   * @param itVkorg 客户售达方
   * @return XfR
   */
  @PatchMapping("/itvkorgs/{id}")
  public XfR patchUpdate(@RequestBody ItVkorg itVkorg,@PathVariable Long id) {
      ItVkorg upitVkorg = itVkorgServiceImpl.getById(id);
      if(upitVkorg != null){
        upitVkorg = ObjectCopyUtils.copyProperties(itVkorg,upitVkorg,true);
      }
      return XfR.ok(itVkorgServiceImpl.updateById(upitVkorg));
  }

  /**
   * 通过id删除客户售达方
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/itvkorgs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(itVkorgServiceImpl.removeById(id));
  }

  @PostMapping("/itvkorgs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "it_vkorg");
     params.put("request", condition);

     return XfR.ok(itVkorgServiceImpl.querys(params));
  }

}
