package com.xforceplus.ultraman.app.wilmarma.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.wilmarma.entity.Makt;
import com.xforceplus.ultraman.app.wilmarma.service.IMaktService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 物料明细前端控制器
 *
 * @author ultraman
 * @date 2024-01-12
 */
@RestController
public class MaktController {

  @Autowired
  private IMaktService maktServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param makt 物料明细
   * @return
   */
  @GetMapping("/makts" )
  public XfR getMakts(XfPage page, Makt makt) {
    return XfR.ok(maktServiceImpl.page(page, Wrappers.query(makt)));
  }

  /**
   * 通过id查询物料明细
   * @param  id
   * @return XfR
   */
  @GetMapping("/makts/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(maktServiceImpl.getById(id));
  }

  /**
   * 新增物料明细
   * @param makt 物料明细
   * @return XfR
   */
  @PostMapping("/makts")
  public XfR save(@RequestBody Makt makt) {
     return XfR.ok(maktServiceImpl.save(makt));
  }

  /**
   * 修改-传入修改后的全部数据物料明细
   * @param makt 物料明细
   * @return XfR
   */
  @PutMapping("/makts/{id}")
  public XfR putUpdate(@RequestBody Makt makt,@PathVariable Long id) {
      makt.setId(id);
      return XfR.ok(maktServiceImpl.updateById(makt));
  }

  /**
   * 修改-传入修改的数据物料明细
   * @param makt 物料明细
   * @return XfR
   */
  @PatchMapping("/makts/{id}")
  public XfR patchUpdate(@RequestBody Makt makt,@PathVariable Long id) {
      Makt upmakt = maktServiceImpl.getById(id);
      if(upmakt != null){
        upmakt = ObjectCopyUtils.copyProperties(makt,upmakt,true);
      }
      return XfR.ok(maktServiceImpl.updateById(upmakt));
  }

  /**
   * 通过id删除物料明细
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/makts/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(maktServiceImpl.removeById(id));
  }

  @PostMapping("/makts/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "makt");
     params.put("request", condition);

     return XfR.ok(maktServiceImpl.querys(params));
  }

}
