package com.xforceplus.ultraman.app.wilmarma.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.wilmarma.entity.Mara;
import com.xforceplus.ultraman.app.wilmarma.service.IMaraService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 物料表头前端控制器
 *
 * @author ultraman
 * @date 2024-01-12
 */
@RestController
public class MaraController {

  @Autowired
  private IMaraService maraServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param mara 物料表头
   * @return
   */
  @GetMapping("/maras" )
  public XfR getMaras(XfPage page, Mara mara) {
    return XfR.ok(maraServiceImpl.page(page, Wrappers.query(mara)));
  }

  /**
   * 通过id查询物料表头
   * @param  id
   * @return XfR
   */
  @GetMapping("/maras/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(maraServiceImpl.getById(id));
  }

  /**
   * 新增物料表头
   * @param mara 物料表头
   * @return XfR
   */
  @PostMapping("/maras")
  public XfR save(@RequestBody Mara mara) {
     return XfR.ok(maraServiceImpl.save(mara));
  }

  /**
   * 修改-传入修改后的全部数据物料表头
   * @param mara 物料表头
   * @return XfR
   */
  @PutMapping("/maras/{id}")
  public XfR putUpdate(@RequestBody Mara mara,@PathVariable Long id) {
      mara.setId(id);
      return XfR.ok(maraServiceImpl.updateById(mara));
  }

  /**
   * 修改-传入修改的数据物料表头
   * @param mara 物料表头
   * @return XfR
   */
  @PatchMapping("/maras/{id}")
  public XfR patchUpdate(@RequestBody Mara mara,@PathVariable Long id) {
      Mara upmara = maraServiceImpl.getById(id);
      if(upmara != null){
        upmara = ObjectCopyUtils.copyProperties(mara,upmara,true);
      }
      return XfR.ok(maraServiceImpl.updateById(upmara));
  }

  /**
   * 通过id删除物料表头
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/maras/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(maraServiceImpl.removeById(id));
  }

  @PostMapping("/maras/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "mara");
     params.put("request", condition);

     return XfR.ok(maraServiceImpl.querys(params));
  }

}
