package com.xforceplus.ultraman.app.wilmarma.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.wilmarma.entity.Marm;
import com.xforceplus.ultraman.app.wilmarma.service.IMarmService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 物料单位前端控制器
 *
 * @author ultraman
 * @date 2024-01-12
 */
@RestController
public class MarmController {

  @Autowired
  private IMarmService marmServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param marm 物料单位
   * @return
   */
  @GetMapping("/marms" )
  public XfR getMarms(XfPage page, Marm marm) {
    return XfR.ok(marmServiceImpl.page(page, Wrappers.query(marm)));
  }

  /**
   * 通过id查询物料单位
   * @param  id
   * @return XfR
   */
  @GetMapping("/marms/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(marmServiceImpl.getById(id));
  }

  /**
   * 新增物料单位
   * @param marm 物料单位
   * @return XfR
   */
  @PostMapping("/marms")
  public XfR save(@RequestBody Marm marm) {
     return XfR.ok(marmServiceImpl.save(marm));
  }

  /**
   * 修改-传入修改后的全部数据物料单位
   * @param marm 物料单位
   * @return XfR
   */
  @PutMapping("/marms/{id}")
  public XfR putUpdate(@RequestBody Marm marm,@PathVariable Long id) {
      marm.setId(id);
      return XfR.ok(marmServiceImpl.updateById(marm));
  }

  /**
   * 修改-传入修改的数据物料单位
   * @param marm 物料单位
   * @return XfR
   */
  @PatchMapping("/marms/{id}")
  public XfR patchUpdate(@RequestBody Marm marm,@PathVariable Long id) {
      Marm upmarm = marmServiceImpl.getById(id);
      if(upmarm != null){
        upmarm = ObjectCopyUtils.copyProperties(marm,upmarm,true);
      }
      return XfR.ok(marmServiceImpl.updateById(upmarm));
  }

  /**
   * 通过id删除物料单位
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/marms/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(marmServiceImpl.removeById(id));
  }

  @PostMapping("/marms/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "marm");
     params.put("request", condition);

     return XfR.ok(marmServiceImpl.querys(params));
  }

}
