package com.xforceplus.ultraman.app.yaceyingyong.metadata.dict;


import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 交通类型
 * </p>
 *
 * @author ultraman
 * @since 2022-11-03
 */
public enum JtType {

    CAR("car", "自驾"),
    TAXT("taxt", "出租车"),
    AIR("air", "飞机"),
    TRAIN("train", "火车");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    JtType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static JtType fromCode(String code){
        switch(code) {
            case "car":
                return CAR;
            case "taxt":
                return TAXT;
            case "air":
                return AIR;
            case "train":
                return TRAIN;
            default:
                return null;
        }
    }
}
