package com.xforceplus.ultraman.app.yaceyingyong.metadata.dict;


import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 角色类型
 * </p>
 *
 * @author ultraman
 * @since 2022-11-03
 */
public enum RoleType {

    MANAGER("manager", "管理"),
    STAFF("staff", "员工"),
    APPROVER("approver", "审批"),
    FINANCE("finance", "财务");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    RoleType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static RoleType fromCode(String code){
        switch(code) {
            case "manager":
                return MANAGER;
            case "staff":
                return STAFF;
            case "approver":
                return APPROVER;
            case "finance":
                return FINANCE;
            default:
                return null;
        }
    }
}
