package com.xforceplus.ultraman.app.yaceyingyong.metadata.entity;

import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * beilookupandjuhe0221
 * </p>
 *
 * @author ultraman
 * @since 2022-11-03
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class Beilookupandjuhe0221 implements Serializable {

  private static final long serialVersionUID=1L;
  /**
   * 字符串
   */
  private String zfc;
  /**
   * 纯数字编号
   */
  private Long cszbh;
  /**
   * 浮点型
   */
  private BigDecimal fdx;
  /**
   * 布尔值
   */
  private Boolean buerzhi;
  /**
   * 时间戳
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime sjc;
  /**
   * 枚举型
   */
  private String mjx;
  /**
   * 整型1
   */
  private Long zx;
  /**
   * 整型2
   */
  private Long zx2;
  /**
   * 公式1
   */
  private Long gongshi;
  /**
   * 公式2
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime gongshi2;
  /**
   * 公式3
   */
  private BigDecimal gongshi3;
  /**
   * id
   */
  private Long id;
  /**
   * 租户id
   */
  private Long tenantId;
  /**
   * 租户代码
   */
  private String tenantCode;
  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;
  /**
   * 修改时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;
  /**
   * 创建人
   */
  private Long createUserId;
  /**
   * 修改人
   */
  private Long updateUserId;
  /**
   * 创建人名字
   */
  private String createUserName;
  /**
   * 修改人名字
   */
  private String updateUserName;
  /**
   * 删除标记
   */
  private String deleteFlag;
  /**
   * 自增编号-简单
   */
  private String zzbhjd;
  /**
   * 自增编号-高级
   */
  private String zzbhgj;


  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("zfc", zfc);
      map.put("cszbh", cszbh);
      map.put("fdx", fdx);
      map.put("buerzhi", buerzhi);
      map.put("sjc", BocpGenUtils.toTimestamp(sjc));
      map.put("mjx", mjx);
      map.put("zx", zx);
      map.put("zx2", zx2);
      map.put("gongshi", gongshi);
      map.put("gongshi2", BocpGenUtils.toTimestamp(gongshi2));
      map.put("gongshi3", gongshi3);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("zzbhjd", zzbhjd);
      map.put("zzbhgj", zzbhgj);

      return map;
  }

  public static Beilookupandjuhe0221 fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    Beilookupandjuhe0221 entity = new Beilookupandjuhe0221();

    if(map.containsKey("zfc")) {
      Object obj = map.get("zfc");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setZfc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cszbh")) {
      Object obj = map.get("cszbh");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCszbh((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCszbh(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCszbh(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("fdx")) {
      Object obj = map.get("fdx");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setFdx((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setFdx(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setFdx(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setFdx(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setFdx(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("buerzhi")) {
      Object obj = map.get("buerzhi");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setBuerzhi((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setBuerzhi(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("sjc")) {
      Object obj = map.get("sjc");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSjc(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setSjc((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSjc(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setSjc(null);
      }
    }
    if(map.containsKey("mjx")) {
      Object obj = map.get("mjx");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setMjx((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("zx")) {
      Object obj = map.get("zx");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setZx((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setZx(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setZx(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("zx2")) {
      Object obj = map.get("zx2");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setZx2((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setZx2(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setZx2(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("gongshi")) {
      Object obj = map.get("gongshi");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setGongshi((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setGongshi(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setGongshi(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("gongshi2")) {
      Object obj = map.get("gongshi2");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setGongshi2(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setGongshi2((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setGongshi2(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setGongshi2(null);
      }
    }
    if(map.containsKey("gongshi3")) {
      Object obj = map.get("gongshi3");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setGongshi3((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setGongshi3(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setGongshi3(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setGongshi3(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setGongshi3(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("zzbhjd")) {
      Object obj = map.get("zzbhjd");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setZzbhjd((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("zzbhgj")) {
      Object obj = map.get("zzbhgj");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setZzbhgj((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("zfc")) {
      Object obj = map.get("zfc");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setZfc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cszbh")) {
      Object obj = map.get("cszbh");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCszbh((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCszbh(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCszbh(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("fdx")) {
      Object obj = map.get("fdx");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setFdx((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setFdx(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setFdx(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setFdx(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setFdx(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("buerzhi")) {
      Object obj = map.get("buerzhi");
      if(obj != null) {
        if(obj instanceof Boolean) {
            this.setBuerzhi((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setBuerzhi(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("sjc")) {
      Object obj = map.get("sjc");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setSjc(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setSjc((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setSjc(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setSjc(null);
      }
    }
    if(map.containsKey("mjx")) {
      Object obj = map.get("mjx");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setMjx((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("zx")) {
      Object obj = map.get("zx");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setZx((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setZx(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setZx(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("zx2")) {
      Object obj = map.get("zx2");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setZx2((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setZx2(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setZx2(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("gongshi")) {
      Object obj = map.get("gongshi");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setGongshi((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setGongshi(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setGongshi(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("gongshi2")) {
      Object obj = map.get("gongshi2");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setGongshi2(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setGongshi2((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setGongshi2(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setGongshi2(null);
      }
    }
    if(map.containsKey("gongshi3")) {
      Object obj = map.get("gongshi3");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setGongshi3((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setGongshi3(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setGongshi3(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setGongshi3(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setGongshi3(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("zzbhjd")) {
      Object obj = map.get("zzbhjd");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setZzbhjd((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("zzbhgj")) {
      Object obj = map.get("zzbhgj");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setZzbhgj((String)obj);
        }
      } else{
      }
    }
  }
}
