package com.xforceplus.ultraman.app.yaceyingyong.metadata.entity;

import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * jichuziduan
 * </p>
 *
 * @author ultraman
 * @since 2022-11-03
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class Jichuziduan implements Serializable {

  private static final long serialVersionUID=1L;
  /**
   * zfc
   */
  private String zfc;
  /**
   * duanwenben
   */
  private String duanwenben;
  /**
   * longwenben
   */
  private String longwenben;
  /**
   * text
   */
  private String text;
  /**
   * url
   */
  private String url;
  /**
   * tupian
   */
  private String tupian;
  /**
   * wenjian
   */
  private String wenjian;
  /**
   * youxiang
   */
  private String youxiang;
  /**
   * shouji
   */
  private String shouji;
  /**
   * diqu
   */
  private String diqu;
  /**
   * zifuji
   */
  private String zifuji;
  /**
   * cszbh
   */
  private Long cszbh;
  /**
   * zx
   */
  private Long zx;
  /**
   * xiaoshu
   */
  private BigDecimal xiaoshu;
  /**
   * jine
   */
  private BigDecimal jine;
  /**
   * baifenbi
   */
  private BigDecimal baifenbi;
  /**
   * buerzhi
   */
  private Boolean buerzhi;
  /**
   * riqi
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime riqi;
  /**
   * meiju
   */
  private String meiju;
  /**
   * duozhimeiju
   */
  private String duozhimeiju;
  /**
   * id
   */
  private Long id;
  /**
   * 租户ID
   */
  private Long tenantId;
  /**
   * 租户代码
   */
  private String tenantCode;
  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;
  /**
   * 修改时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;
  /**
   * 创建人ID
   */
  private Long createUserId;
  /**
   * 修改人ID
   */
  private Long updateUserId;
  /**
   * 创建人名字
   */
  private String createUserName;
  /**
   * 修改人名字
   */
  private String updateUserName;
  /**
   * 删除标记
   */
  private String deleteFlag;


  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("zfc", zfc);
      map.put("duanwenben", duanwenben);
      map.put("longwenben", longwenben);
      map.put("text", text);
      map.put("url", url);
      map.put("tupian", tupian);
      map.put("wenjian", wenjian);
      map.put("youxiang", youxiang);
      map.put("shouji", shouji);
      map.put("diqu", diqu);
      map.put("zifuji", zifuji);
      map.put("cszbh", cszbh);
      map.put("zx", zx);
      map.put("xiaoshu", xiaoshu);
      map.put("jine", jine);
      map.put("baifenbi", baifenbi);
      map.put("buerzhi", buerzhi);
      map.put("riqi", BocpGenUtils.toTimestamp(riqi));
      map.put("meiju", meiju);
      map.put("duozhimeiju", duozhimeiju);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);

      return map;
  }

  public static Jichuziduan fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    Jichuziduan entity = new Jichuziduan();

    if(map.containsKey("zfc")) {
      Object obj = map.get("zfc");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setZfc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("duanwenben")) {
      Object obj = map.get("duanwenben");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDuanwenben((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("longwenben")) {
      Object obj = map.get("longwenben");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setLongwenben((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("text")) {
      Object obj = map.get("text");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setText((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("url")) {
      Object obj = map.get("url");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUrl((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tupian")) {
      Object obj = map.get("tupian");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTupian((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("wenjian")) {
      Object obj = map.get("wenjian");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setWenjian((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("youxiang")) {
      Object obj = map.get("youxiang");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setYouxiang((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("shouji")) {
      Object obj = map.get("shouji");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setShouji((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("diqu")) {
      Object obj = map.get("diqu");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDiqu((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("zifuji")) {
      Object obj = map.get("zifuji");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setZifuji((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cszbh")) {
      Object obj = map.get("cszbh");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCszbh((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCszbh(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCszbh(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("zx")) {
      Object obj = map.get("zx");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setZx((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setZx(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setZx(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("xiaoshu")) {
      Object obj = map.get("xiaoshu");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setXiaoshu((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setXiaoshu(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setXiaoshu(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setXiaoshu(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setXiaoshu(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("jine")) {
      Object obj = map.get("jine");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setJine((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setJine(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setJine(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setJine(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setJine(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("baifenbi")) {
      Object obj = map.get("baifenbi");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setBaifenbi((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setBaifenbi(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setBaifenbi(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setBaifenbi(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setBaifenbi(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("buerzhi")) {
      Object obj = map.get("buerzhi");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setBuerzhi((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setBuerzhi(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("riqi")) {
      Object obj = map.get("riqi");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setRiqi(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setRiqi((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setRiqi(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setRiqi(null);
      }
    }
    if(map.containsKey("meiju")) {
      Object obj = map.get("meiju");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setMeiju((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("duozhimeiju")) {
      Object obj = map.get("duozhimeiju");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDuozhimeiju((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("zfc")) {
      Object obj = map.get("zfc");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setZfc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("duanwenben")) {
      Object obj = map.get("duanwenben");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDuanwenben((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("longwenben")) {
      Object obj = map.get("longwenben");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setLongwenben((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("text")) {
      Object obj = map.get("text");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setText((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("url")) {
      Object obj = map.get("url");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setUrl((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tupian")) {
      Object obj = map.get("tupian");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTupian((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("wenjian")) {
      Object obj = map.get("wenjian");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setWenjian((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("youxiang")) {
      Object obj = map.get("youxiang");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setYouxiang((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("shouji")) {
      Object obj = map.get("shouji");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setShouji((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("diqu")) {
      Object obj = map.get("diqu");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDiqu((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("zifuji")) {
      Object obj = map.get("zifuji");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setZifuji((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cszbh")) {
      Object obj = map.get("cszbh");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCszbh((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCszbh(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCszbh(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("zx")) {
      Object obj = map.get("zx");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setZx((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setZx(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setZx(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("xiaoshu")) {
      Object obj = map.get("xiaoshu");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setXiaoshu((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setXiaoshu(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setXiaoshu(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setXiaoshu(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setXiaoshu(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("jine")) {
      Object obj = map.get("jine");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setJine((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setJine(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setJine(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setJine(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setJine(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("baifenbi")) {
      Object obj = map.get("baifenbi");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setBaifenbi((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setBaifenbi(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setBaifenbi(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setBaifenbi(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setBaifenbi(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("buerzhi")) {
      Object obj = map.get("buerzhi");
      if(obj != null) {
        if(obj instanceof Boolean) {
            this.setBuerzhi((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setBuerzhi(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("riqi")) {
      Object obj = map.get("riqi");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setRiqi(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setRiqi((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setRiqi(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setRiqi(null);
      }
    }
    if(map.containsKey("meiju")) {
      Object obj = map.get("meiju");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setMeiju((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("duozhimeiju")) {
      Object obj = map.get("duozhimeiju");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDuozhimeiju((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
  }
}
