package com.xforceplus.ultraman.app.yaceyingyong.metadata.entity;

import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * sales_bill_details1
 * </p>
 *
 * @author ultraman
 * @since 2022-11-03
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class SalesBillDetails1 implements Serializable {

  private static final long serialVersionUID=1L;
  /**
   * 明细编号
   */
  private String salesbillItemNo;
  /**
   * 货物或应税劳务名称 
   */
  private String itemName;
  /**
   * 规格型号
   */
  private String itemSpec;
  /**
   * 数量单位
   */
  private String quantityUnit;
  /**
   * 不含税单价
   */
  private BigDecimal unitPrice;
  /**
   * 扣除额
   */
  private BigDecimal deduction;
  /**
   * 数量
   */
  private BigDecimal quantity;
  /**
   * 不含税金额
   */
  private BigDecimal amountWithoutTax;
  /**
   * 税率
   */
  private BigDecimal taxRate;
  /**
   * 税额
   */
  private BigDecimal taxAmount;
  /**
   * 含税金额
   */
  private BigDecimal amountWithTax;
  /**
   * 税收分类编码
   */
  private String goodsTaxNo;
  /**
   * 税收分类转换代码
   */
  private String taxConvertCode;
  /**
   * 是否享受税收优惠政策
   */
  private String taxPre;
  /**
   * 税收优惠
   */
  private String taxPreCon;
  /**
   * 零税率标志
   */
  private String zeroTax;
  /**
   * 拓展字段
   */
  private String ext1;
  /**
   * 拓展字段
   */
  private String ext2;
  /**
   * salesbillId
   */
  private Long salesbillId;
  /**
   * 价外折扣税额
   */
  private BigDecimal outterDiscountTax;
  /**
   * 价外含税折扣
   */
  private BigDecimal outterDiscountWithTax;
  /**
   * 价外不含税折扣
   */
  private BigDecimal outterDiscountWithoutTax;
  /**
   * 货物及服务代码
   */
  private String itemCode;
  /**
   * 扣除额
   */
  private BigDecimal deductions;
  /**
   * id
   */
  private Long id;
  /**
   * 租户ID
   */
  private Long tenantId;
  /**
   * 租户代码
   */
  private String tenantCode;
  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;
  /**
   * 修改时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;
  /**
   * 创建人ID
   */
  private Long createUserId;
  /**
   * 修改人ID
   */
  private Long updateUserId;
  /**
   * 创建人名字
   */
  private String createUserName;
  /**
   * 修改人名字
   */
  private String updateUserName;
  /**
   * 删除标记
   */
  private String deleteFlag;
  /**
   * shijiandeatils
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime shijiandeatils;

  /**
   * 对一关联关系 关联对象 salesBillmain1
   */
  private Long yiduiduo04014002Id;

  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("salesbillItemNo", salesbillItemNo);
      map.put("itemName", itemName);
      map.put("itemSpec", itemSpec);
      map.put("quantityUnit", quantityUnit);
      map.put("unitPrice", unitPrice);
      map.put("deduction", deduction);
      map.put("quantity", quantity);
      map.put("amountWithoutTax", amountWithoutTax);
      map.put("taxRate", taxRate);
      map.put("taxAmount", taxAmount);
      map.put("amountWithTax", amountWithTax);
      map.put("goodsTaxNo", goodsTaxNo);
      map.put("taxConvertCode", taxConvertCode);
      map.put("taxPre", taxPre);
      map.put("taxPreCon", taxPreCon);
      map.put("zeroTax", zeroTax);
      map.put("ext1", ext1);
      map.put("ext2", ext2);
      map.put("salesbillId", salesbillId);
      map.put("outterDiscountTax", outterDiscountTax);
      map.put("outterDiscountWithTax", outterDiscountWithTax);
      map.put("outterDiscountWithoutTax", outterDiscountWithoutTax);
      map.put("itemCode", itemCode);
      map.put("deductions", deductions);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("shijiandeatils", BocpGenUtils.toTimestamp(shijiandeatils));

      map.put("yiduiduo04014002.id", yiduiduo04014002Id);
      return map;
  }

  public static SalesBillDetails1 fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    SalesBillDetails1 entity = new SalesBillDetails1();

    if(map.containsKey("salesbillItemNo")) {
      Object obj = map.get("salesbillItemNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSalesbillItemNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("itemName")) {
      Object obj = map.get("itemName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setItemName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("itemSpec")) {
      Object obj = map.get("itemSpec");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setItemSpec((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("quantityUnit")) {
      Object obj = map.get("quantityUnit");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setQuantityUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("unitPrice")) {
      Object obj = map.get("unitPrice");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setUnitPrice((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setUnitPrice(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setUnitPrice(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUnitPrice(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUnitPrice(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("deduction")) {
      Object obj = map.get("deduction");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setDeduction((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setDeduction(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setDeduction(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setDeduction(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setDeduction(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("quantity")) {
      Object obj = map.get("quantity");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setQuantity((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setQuantity(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setQuantity(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setQuantity(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setQuantity(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("amountWithoutTax")) {
      Object obj = map.get("amountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("taxRate")) {
      Object obj = map.get("taxRate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTaxRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTaxRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTaxRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTaxRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTaxRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("taxAmount")) {
      Object obj = map.get("taxAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("amountWithTax")) {
      Object obj = map.get("amountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("goodsTaxNo")) {
      Object obj = map.get("goodsTaxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setGoodsTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxConvertCode")) {
      Object obj = map.get("taxConvertCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTaxConvertCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxPre")) {
      Object obj = map.get("taxPre");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTaxPre((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxPreCon")) {
      Object obj = map.get("taxPreCon");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTaxPreCon((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("zeroTax")) {
      Object obj = map.get("zeroTax");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setZeroTax((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext1")) {
      Object obj = map.get("ext1");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt1((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext2")) {
      Object obj = map.get("ext2");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt2((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("salesbillId")) {
      Object obj = map.get("salesbillId");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSalesbillId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSalesbillId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setSalesbillId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("outterDiscountTax")) {
      Object obj = map.get("outterDiscountTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setOutterDiscountTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setOutterDiscountTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setOutterDiscountTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setOutterDiscountTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setOutterDiscountTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("outterDiscountWithTax")) {
      Object obj = map.get("outterDiscountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setOutterDiscountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setOutterDiscountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setOutterDiscountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setOutterDiscountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setOutterDiscountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("outterDiscountWithoutTax")) {
      Object obj = map.get("outterDiscountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setOutterDiscountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setOutterDiscountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setOutterDiscountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setOutterDiscountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setOutterDiscountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("itemCode")) {
      Object obj = map.get("itemCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setItemCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("deductions")) {
      Object obj = map.get("deductions");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setDeductions((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setDeductions(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setDeductions(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setDeductions(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setDeductions(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("shijiandeatils")) {
      Object obj = map.get("shijiandeatils");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setShijiandeatils(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setShijiandeatils((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setShijiandeatils(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setShijiandeatils(null);
      }
    }

    if(map.containsKey("yiduiduo04014002.id")) {
       Object obj = map.get("yiduiduo04014002.id");
       if(obj instanceof Long) {
         entity.setYiduiduo04014002Id((Long)obj);
       } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
         entity.setYiduiduo04014002Id(Long.parseLong((String)obj));
       }
    }
    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("salesbillItemNo")) {
      Object obj = map.get("salesbillItemNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSalesbillItemNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("itemName")) {
      Object obj = map.get("itemName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setItemName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("itemSpec")) {
      Object obj = map.get("itemSpec");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setItemSpec((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("quantityUnit")) {
      Object obj = map.get("quantityUnit");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setQuantityUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("unitPrice")) {
      Object obj = map.get("unitPrice");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setUnitPrice((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setUnitPrice(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setUnitPrice(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUnitPrice(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setUnitPrice(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("deduction")) {
      Object obj = map.get("deduction");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setDeduction((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setDeduction(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setDeduction(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setDeduction(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setDeduction(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("quantity")) {
      Object obj = map.get("quantity");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setQuantity((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setQuantity(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setQuantity(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setQuantity(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setQuantity(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("amountWithoutTax")) {
      Object obj = map.get("amountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("taxRate")) {
      Object obj = map.get("taxRate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setTaxRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setTaxRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setTaxRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTaxRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setTaxRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("taxAmount")) {
      Object obj = map.get("taxAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("amountWithTax")) {
      Object obj = map.get("amountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("goodsTaxNo")) {
      Object obj = map.get("goodsTaxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setGoodsTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxConvertCode")) {
      Object obj = map.get("taxConvertCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTaxConvertCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxPre")) {
      Object obj = map.get("taxPre");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTaxPre((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxPreCon")) {
      Object obj = map.get("taxPreCon");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTaxPreCon((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("zeroTax")) {
      Object obj = map.get("zeroTax");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setZeroTax((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext1")) {
      Object obj = map.get("ext1");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setExt1((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext2")) {
      Object obj = map.get("ext2");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setExt2((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("salesbillId")) {
      Object obj = map.get("salesbillId");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setSalesbillId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setSalesbillId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setSalesbillId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("outterDiscountTax")) {
      Object obj = map.get("outterDiscountTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setOutterDiscountTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setOutterDiscountTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setOutterDiscountTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setOutterDiscountTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setOutterDiscountTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("outterDiscountWithTax")) {
      Object obj = map.get("outterDiscountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setOutterDiscountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setOutterDiscountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setOutterDiscountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setOutterDiscountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setOutterDiscountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("outterDiscountWithoutTax")) {
      Object obj = map.get("outterDiscountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setOutterDiscountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setOutterDiscountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setOutterDiscountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setOutterDiscountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setOutterDiscountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("itemCode")) {
      Object obj = map.get("itemCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setItemCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("deductions")) {
      Object obj = map.get("deductions");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setDeductions((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setDeductions(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setDeductions(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setDeductions(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setDeductions(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("shijiandeatils")) {
      Object obj = map.get("shijiandeatils");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setShijiandeatils(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setShijiandeatils((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setShijiandeatils(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setShijiandeatils(null);
      }
    }
  if(map.containsKey("yiduiduo04014002.id")) {
    Object obj = map.get("yiduiduo04014002.id");
    if(obj instanceof Long) {
        this.setYiduiduo04014002Id((Long)obj);
    } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
        this.setYiduiduo04014002Id(Long.parseLong((String)obj));
    }
  }
  }
}
