package com.xforceplus.ultraman.app.yaceyingyong.metadata.entity;

import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * testjuhe1115001
 * </p>
 *
 * @author ultraman
 * @since 2022-11-03
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class Testjuhe1115001 implements Serializable {

  private static final long serialVersionUID=1L;
  /**
   * 聚合-对象
   */
  private String zfc;
  /**
   * id
   */
  private Long id;
  /**
   * 租户ID
   */
  private Long tenantId;
  /**
   * 租户代码
   */
  private String tenantCode;
  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;
  /**
   * 修改时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;
  /**
   * 创建人ID
   */
  private Long createUserId;
  /**
   * 修改人ID
   */
  private Long updateUserId;
  /**
   * 创建人名字
   */
  private String createUserName;
  /**
   * 修改人名字
   */
  private String updateUserName;
  /**
   * 删除标记
   */
  private String deleteFlag;
  /**
   * 全-sum-整型
   */
  private Long juhesumzx;
  /**
   * 全-sum-浮点型
   */
  private BigDecimal juhesumfdx;
  /**
   * 全-sum-gs整型
   */
  private Long juhesumgszx;
  /**
   * 全-sum-gs浮点型
   */
  private BigDecimal juhesumgsfdx;
  /**
   * 普通类型-sum-整型
   */
  private Long ptlxsumzx;
  /**
   * 普通类型-sum-浮点型
   */
  private BigDecimal ptlxsumfdx;
  /**
   * 公式-sum-整型
   */
  private Long gssumzx;
  /**
   * 公式-sum-浮点型
   */
  private BigDecimal gssumfdx;


  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("zfc", zfc);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("juhesumzx", juhesumzx);
      map.put("juhesumfdx", juhesumfdx);
      map.put("juhesumgszx", juhesumgszx);
      map.put("juhesumgsfdx", juhesumgsfdx);
      map.put("ptlxsumzx", ptlxsumzx);
      map.put("ptlxsumfdx", ptlxsumfdx);
      map.put("gssumzx", gssumzx);
      map.put("gssumfdx", gssumfdx);

      return map;
  }

  public static Testjuhe1115001 fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    Testjuhe1115001 entity = new Testjuhe1115001();

    if(map.containsKey("zfc")) {
      Object obj = map.get("zfc");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setZfc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("juhesumzx")) {
      Object obj = map.get("juhesumzx");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setJuhesumzx((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setJuhesumzx(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setJuhesumzx(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("juhesumfdx")) {
      Object obj = map.get("juhesumfdx");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setJuhesumfdx((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setJuhesumfdx(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setJuhesumfdx(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setJuhesumfdx(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setJuhesumfdx(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("juhesumgszx")) {
      Object obj = map.get("juhesumgszx");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setJuhesumgszx((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setJuhesumgszx(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setJuhesumgszx(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("juhesumgsfdx")) {
      Object obj = map.get("juhesumgsfdx");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setJuhesumgsfdx((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setJuhesumgsfdx(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setJuhesumgsfdx(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setJuhesumgsfdx(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setJuhesumgsfdx(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("ptlxsumzx")) {
      Object obj = map.get("ptlxsumzx");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPtlxsumzx((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPtlxsumzx(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setPtlxsumzx(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("ptlxsumfdx")) {
      Object obj = map.get("ptlxsumfdx");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPtlxsumfdx((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPtlxsumfdx(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPtlxsumfdx(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPtlxsumfdx(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPtlxsumfdx(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("gssumzx")) {
      Object obj = map.get("gssumzx");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setGssumzx((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setGssumzx(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setGssumzx(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("gssumfdx")) {
      Object obj = map.get("gssumfdx");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setGssumfdx((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setGssumfdx(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setGssumfdx(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setGssumfdx(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setGssumfdx(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("zfc")) {
      Object obj = map.get("zfc");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setZfc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("juhesumzx")) {
      Object obj = map.get("juhesumzx");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setJuhesumzx((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setJuhesumzx(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setJuhesumzx(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("juhesumfdx")) {
      Object obj = map.get("juhesumfdx");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setJuhesumfdx((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setJuhesumfdx(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setJuhesumfdx(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setJuhesumfdx(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setJuhesumfdx(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("juhesumgszx")) {
      Object obj = map.get("juhesumgszx");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setJuhesumgszx((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setJuhesumgszx(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setJuhesumgszx(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("juhesumgsfdx")) {
      Object obj = map.get("juhesumgsfdx");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setJuhesumgsfdx((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setJuhesumgsfdx(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setJuhesumgsfdx(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setJuhesumgsfdx(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setJuhesumgsfdx(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("ptlxsumzx")) {
      Object obj = map.get("ptlxsumzx");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setPtlxsumzx((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setPtlxsumzx(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setPtlxsumzx(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("ptlxsumfdx")) {
      Object obj = map.get("ptlxsumfdx");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setPtlxsumfdx((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setPtlxsumfdx(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setPtlxsumfdx(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setPtlxsumfdx(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setPtlxsumfdx(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("gssumzx")) {
      Object obj = map.get("gssumzx");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setGssumzx((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setGssumzx(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setGssumzx(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("gssumfdx")) {
      Object obj = map.get("gssumfdx");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setGssumfdx((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setGssumfdx(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setGssumfdx(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setGssumfdx(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setGssumfdx(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
  }
}
