package com.xforceplus.ultraman.app.yaceyingyong.metadata.entity;

import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * testjuhe1115002
 * </p>
 *
 * @author ultraman
 * @since 2022-11-03
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class Testjuhe1115002 implements Serializable {

  private static final long serialVersionUID=1L;
  /**
   * 聚合-对象
   */
  private String zfc;
  /**
   * id
   */
  private Long id;
  /**
   * 租户ID
   */
  private Long tenantId;
  /**
   * 租户代码
   */
  private String tenantCode;
  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;
  /**
   * 修改时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;
  /**
   * 创建人ID
   */
  private Long createUserId;
  /**
   * 修改人ID
   */
  private Long updateUserId;
  /**
   * 创建人名字
   */
  private String createUserName;
  /**
   * 修改人名字
   */
  private String updateUserName;
  /**
   * 删除标记
   */
  private String deleteFlag;
  /**
   * 全-min-整型
   */
  private Long quanminzx;
  /**
   * 全-min-浮点型
   */
  private BigDecimal quanminfdx;
  /**
   * 全-min-时间戳
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime quanminsjc;
  /**
   * 全-min-gs整型
   */
  private Long quanmingszx;
  /**
   * 全-min-gs浮点型
   */
  private BigDecimal quanmingsfdx;
  /**
   * 全-min-gs时间戳
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime quanmingssjc;
  /**
   * 普通类型-min-整型
   */
  private Long ptlxminzx;
  /**
   * 普通类型-min-浮点型
   */
  private BigDecimal ptlxminfdx;
  /**
   * 普通类型-min-时间戳
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime ptlxminsjc;
  /**
   * 公式-min-整型
   */
  private Long gsminzx;
  /**
   * 公式-min-浮点型
   */
  private BigDecimal gsminfdx;
  /**
   * 公式-min-时间戳
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime gsminsjc;


  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("zfc", zfc);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("quanminzx", quanminzx);
      map.put("quanminfdx", quanminfdx);
      map.put("quanminsjc", BocpGenUtils.toTimestamp(quanminsjc));
      map.put("quanmingszx", quanmingszx);
      map.put("quanmingsfdx", quanmingsfdx);
      map.put("quanmingssjc", BocpGenUtils.toTimestamp(quanmingssjc));
      map.put("ptlxminzx", ptlxminzx);
      map.put("ptlxminfdx", ptlxminfdx);
      map.put("ptlxminsjc", BocpGenUtils.toTimestamp(ptlxminsjc));
      map.put("gsminzx", gsminzx);
      map.put("gsminfdx", gsminfdx);
      map.put("gsminsjc", BocpGenUtils.toTimestamp(gsminsjc));

      return map;
  }

  public static Testjuhe1115002 fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    Testjuhe1115002 entity = new Testjuhe1115002();

    if(map.containsKey("zfc")) {
      Object obj = map.get("zfc");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setZfc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("quanminzx")) {
      Object obj = map.get("quanminzx");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setQuanminzx((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setQuanminzx(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setQuanminzx(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("quanminfdx")) {
      Object obj = map.get("quanminfdx");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setQuanminfdx((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setQuanminfdx(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setQuanminfdx(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setQuanminfdx(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setQuanminfdx(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("quanminsjc")) {
      Object obj = map.get("quanminsjc");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setQuanminsjc(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setQuanminsjc((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setQuanminsjc(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setQuanminsjc(null);
      }
    }
    if(map.containsKey("quanmingszx")) {
      Object obj = map.get("quanmingszx");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setQuanmingszx((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setQuanmingszx(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setQuanmingszx(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("quanmingsfdx")) {
      Object obj = map.get("quanmingsfdx");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setQuanmingsfdx((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setQuanmingsfdx(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setQuanmingsfdx(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setQuanmingsfdx(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setQuanmingsfdx(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("quanmingssjc")) {
      Object obj = map.get("quanmingssjc");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setQuanmingssjc(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setQuanmingssjc((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setQuanmingssjc(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setQuanmingssjc(null);
      }
    }
    if(map.containsKey("ptlxminzx")) {
      Object obj = map.get("ptlxminzx");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPtlxminzx((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPtlxminzx(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setPtlxminzx(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("ptlxminfdx")) {
      Object obj = map.get("ptlxminfdx");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPtlxminfdx((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPtlxminfdx(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPtlxminfdx(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPtlxminfdx(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPtlxminfdx(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("ptlxminsjc")) {
      Object obj = map.get("ptlxminsjc");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPtlxminsjc(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setPtlxminsjc((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPtlxminsjc(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setPtlxminsjc(null);
      }
    }
    if(map.containsKey("gsminzx")) {
      Object obj = map.get("gsminzx");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setGsminzx((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setGsminzx(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setGsminzx(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("gsminfdx")) {
      Object obj = map.get("gsminfdx");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setGsminfdx((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setGsminfdx(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setGsminfdx(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setGsminfdx(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setGsminfdx(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("gsminsjc")) {
      Object obj = map.get("gsminsjc");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setGsminsjc(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setGsminsjc((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setGsminsjc(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setGsminsjc(null);
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("zfc")) {
      Object obj = map.get("zfc");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setZfc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("quanminzx")) {
      Object obj = map.get("quanminzx");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setQuanminzx((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setQuanminzx(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setQuanminzx(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("quanminfdx")) {
      Object obj = map.get("quanminfdx");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setQuanminfdx((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setQuanminfdx(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setQuanminfdx(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setQuanminfdx(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setQuanminfdx(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("quanminsjc")) {
      Object obj = map.get("quanminsjc");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setQuanminsjc(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setQuanminsjc((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setQuanminsjc(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setQuanminsjc(null);
      }
    }
    if(map.containsKey("quanmingszx")) {
      Object obj = map.get("quanmingszx");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setQuanmingszx((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setQuanmingszx(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setQuanmingszx(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("quanmingsfdx")) {
      Object obj = map.get("quanmingsfdx");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setQuanmingsfdx((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setQuanmingsfdx(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setQuanmingsfdx(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setQuanmingsfdx(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setQuanmingsfdx(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("quanmingssjc")) {
      Object obj = map.get("quanmingssjc");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setQuanmingssjc(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setQuanmingssjc((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setQuanmingssjc(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setQuanmingssjc(null);
      }
    }
    if(map.containsKey("ptlxminzx")) {
      Object obj = map.get("ptlxminzx");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setPtlxminzx((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setPtlxminzx(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setPtlxminzx(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("ptlxminfdx")) {
      Object obj = map.get("ptlxminfdx");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setPtlxminfdx((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setPtlxminfdx(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setPtlxminfdx(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setPtlxminfdx(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setPtlxminfdx(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("ptlxminsjc")) {
      Object obj = map.get("ptlxminsjc");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setPtlxminsjc(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setPtlxminsjc((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setPtlxminsjc(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setPtlxminsjc(null);
      }
    }
    if(map.containsKey("gsminzx")) {
      Object obj = map.get("gsminzx");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setGsminzx((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setGsminzx(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setGsminzx(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("gsminfdx")) {
      Object obj = map.get("gsminfdx");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setGsminfdx((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setGsminfdx(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setGsminfdx(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setGsminfdx(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setGsminfdx(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("gsminsjc")) {
      Object obj = map.get("gsminsjc");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setGsminsjc(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setGsminsjc((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setGsminsjc(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setGsminsjc(null);
      }
    }
  }
}
