package com.xforceplus.ultraman.app.yaceyingyong.metadata.entity;

import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * testjuhe1115003
 * </p>
 *
 * @author ultraman
 * @since 2022-11-03
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class Testjuhe1115003 implements Serializable {

  private static final long serialVersionUID=1L;
  /**
   * 聚合对象-max
   */
  private String zfc;
  /**
   * id
   */
  private Long id;
  /**
   * 租户ID
   */
  private Long tenantId;
  /**
   * 租户代码
   */
  private String tenantCode;
  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;
  /**
   * 修改时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;
  /**
   * 创建人ID
   */
  private Long createUserId;
  /**
   * 修改人ID
   */
  private Long updateUserId;
  /**
   * 创建人名字
   */
  private String createUserName;
  /**
   * 修改人名字
   */
  private String updateUserName;
  /**
   * 删除标记
   */
  private String deleteFlag;
  /**
   * 全-max-整型
   */
  private Long quanmaxzx;
  /**
   * 全-max-浮点型
   */
  private BigDecimal quanmaxfdx;
  /**
   * 全-max-时间戳
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime quanmaxsjc;
  /**
   * 全-max-gs整型
   */
  private Long quanmaxgszx;
  /**
   * 全-max-gs浮点型
   */
  private BigDecimal quanmaxgsfdx;
  /**
   * 全-max-gs时间戳
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime quanmaxgssjc;
  /**
   * 普通类型-max-整型
   */
  private Long ptlxmaxzx;
  /**
   * 普通类型-max-浮点型
   */
  private BigDecimal ptlxmaxfdx;
  /**
   * 普通类型-max-时间戳
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime ptlxmaxsjc;
  /**
   * 公式-max-整型
   */
  private Long gsmaxzx;
  /**
   * 公式-max-浮点型
   */
  private BigDecimal gsmaxfdx;
  /**
   * 公式-max-时间戳
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime gsmaxsjc;


  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("zfc", zfc);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("quanmaxzx", quanmaxzx);
      map.put("quanmaxfdx", quanmaxfdx);
      map.put("quanmaxsjc", BocpGenUtils.toTimestamp(quanmaxsjc));
      map.put("quanmaxgszx", quanmaxgszx);
      map.put("quanmaxgsfdx", quanmaxgsfdx);
      map.put("quanmaxgssjc", BocpGenUtils.toTimestamp(quanmaxgssjc));
      map.put("ptlxmaxzx", ptlxmaxzx);
      map.put("ptlxmaxfdx", ptlxmaxfdx);
      map.put("ptlxmaxsjc", BocpGenUtils.toTimestamp(ptlxmaxsjc));
      map.put("gsmaxzx", gsmaxzx);
      map.put("gsmaxfdx", gsmaxfdx);
      map.put("gsmaxsjc", BocpGenUtils.toTimestamp(gsmaxsjc));

      return map;
  }

  public static Testjuhe1115003 fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    Testjuhe1115003 entity = new Testjuhe1115003();

    if(map.containsKey("zfc")) {
      Object obj = map.get("zfc");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setZfc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("quanmaxzx")) {
      Object obj = map.get("quanmaxzx");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setQuanmaxzx((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setQuanmaxzx(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setQuanmaxzx(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("quanmaxfdx")) {
      Object obj = map.get("quanmaxfdx");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setQuanmaxfdx((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setQuanmaxfdx(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setQuanmaxfdx(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setQuanmaxfdx(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setQuanmaxfdx(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("quanmaxsjc")) {
      Object obj = map.get("quanmaxsjc");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setQuanmaxsjc(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setQuanmaxsjc((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setQuanmaxsjc(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setQuanmaxsjc(null);
      }
    }
    if(map.containsKey("quanmaxgszx")) {
      Object obj = map.get("quanmaxgszx");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setQuanmaxgszx((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setQuanmaxgszx(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setQuanmaxgszx(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("quanmaxgsfdx")) {
      Object obj = map.get("quanmaxgsfdx");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setQuanmaxgsfdx((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setQuanmaxgsfdx(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setQuanmaxgsfdx(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setQuanmaxgsfdx(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setQuanmaxgsfdx(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("quanmaxgssjc")) {
      Object obj = map.get("quanmaxgssjc");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setQuanmaxgssjc(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setQuanmaxgssjc((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setQuanmaxgssjc(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setQuanmaxgssjc(null);
      }
    }
    if(map.containsKey("ptlxmaxzx")) {
      Object obj = map.get("ptlxmaxzx");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPtlxmaxzx((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPtlxmaxzx(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setPtlxmaxzx(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("ptlxmaxfdx")) {
      Object obj = map.get("ptlxmaxfdx");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPtlxmaxfdx((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPtlxmaxfdx(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPtlxmaxfdx(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPtlxmaxfdx(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPtlxmaxfdx(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("ptlxmaxsjc")) {
      Object obj = map.get("ptlxmaxsjc");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPtlxmaxsjc(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setPtlxmaxsjc((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPtlxmaxsjc(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setPtlxmaxsjc(null);
      }
    }
    if(map.containsKey("gsmaxzx")) {
      Object obj = map.get("gsmaxzx");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setGsmaxzx((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setGsmaxzx(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setGsmaxzx(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("gsmaxfdx")) {
      Object obj = map.get("gsmaxfdx");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setGsmaxfdx((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setGsmaxfdx(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setGsmaxfdx(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setGsmaxfdx(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setGsmaxfdx(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("gsmaxsjc")) {
      Object obj = map.get("gsmaxsjc");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setGsmaxsjc(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setGsmaxsjc((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setGsmaxsjc(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setGsmaxsjc(null);
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("zfc")) {
      Object obj = map.get("zfc");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setZfc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("quanmaxzx")) {
      Object obj = map.get("quanmaxzx");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setQuanmaxzx((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setQuanmaxzx(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setQuanmaxzx(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("quanmaxfdx")) {
      Object obj = map.get("quanmaxfdx");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setQuanmaxfdx((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setQuanmaxfdx(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setQuanmaxfdx(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setQuanmaxfdx(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setQuanmaxfdx(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("quanmaxsjc")) {
      Object obj = map.get("quanmaxsjc");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setQuanmaxsjc(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setQuanmaxsjc((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setQuanmaxsjc(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setQuanmaxsjc(null);
      }
    }
    if(map.containsKey("quanmaxgszx")) {
      Object obj = map.get("quanmaxgszx");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setQuanmaxgszx((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setQuanmaxgszx(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setQuanmaxgszx(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("quanmaxgsfdx")) {
      Object obj = map.get("quanmaxgsfdx");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setQuanmaxgsfdx((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setQuanmaxgsfdx(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setQuanmaxgsfdx(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setQuanmaxgsfdx(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setQuanmaxgsfdx(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("quanmaxgssjc")) {
      Object obj = map.get("quanmaxgssjc");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setQuanmaxgssjc(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setQuanmaxgssjc((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setQuanmaxgssjc(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setQuanmaxgssjc(null);
      }
    }
    if(map.containsKey("ptlxmaxzx")) {
      Object obj = map.get("ptlxmaxzx");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setPtlxmaxzx((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setPtlxmaxzx(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setPtlxmaxzx(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("ptlxmaxfdx")) {
      Object obj = map.get("ptlxmaxfdx");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setPtlxmaxfdx((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setPtlxmaxfdx(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setPtlxmaxfdx(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setPtlxmaxfdx(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setPtlxmaxfdx(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("ptlxmaxsjc")) {
      Object obj = map.get("ptlxmaxsjc");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setPtlxmaxsjc(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setPtlxmaxsjc((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setPtlxmaxsjc(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setPtlxmaxsjc(null);
      }
    }
    if(map.containsKey("gsmaxzx")) {
      Object obj = map.get("gsmaxzx");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setGsmaxzx((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setGsmaxzx(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setGsmaxzx(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("gsmaxfdx")) {
      Object obj = map.get("gsmaxfdx");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setGsmaxfdx((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setGsmaxfdx(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setGsmaxfdx(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setGsmaxfdx(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setGsmaxfdx(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("gsmaxsjc")) {
      Object obj = map.get("gsmaxsjc");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setGsmaxsjc(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setGsmaxsjc((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setGsmaxsjc(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setGsmaxsjc(null);
      }
    }
  }
}
