package com.xforceplus.ultraman.app.yaceyingyong.metadata.entity;

import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * testyace
 * </p>
 *
 * @author ultraman
 * @since 2022-11-03
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class Testyace implements Serializable {

  private static final long serialVersionUID=1L;
  /**
   * id
   */
  private Long id;
  /**
   * 租户id
   */
  private Long tenantId;
  /**
   * 租户代码
   */
  private String tenantCode;
  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;
  /**
   * 修改时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;
  /**
   * 创建人ID
   */
  private Long createUserId;
  /**
   * 修改人ID
   */
  private Long updateUserId;
  /**
   * 创建人名字
   */
  private String createUserName;
  /**
   * 修改人名字
   */
  private String updateUserName;
  /**
   * 删除标记
   */
  private String deleteFlag;
  /**
   * 短文本
   */
  private String shortTextField;
  /**
   * 长文本
   */
  private String longTextField;
  /**
   * URL
   */
  private String urlField;
  /**
   * 邮箱
   */
  private String emailField;
  /**
   * 电话
   */
  private String phoneField;
  /**
   * 地区
   */
  private String areaField;
  /**
   * 字符串集合
   */
  private String stringsField;
  /**
   * 数字编号
   */
  private Long serialNoField;
  /**
   * 整数
   */
  private Long intField;
  /**
   * 字符串
   */
  private String stringField;
  /**
   * 小数
   */
  private BigDecimal decimalField;
  /**
   * 金额
   */
  private BigDecimal amountField;
  /**
   * 百分比
   */
  private BigDecimal percentField;
  /**
   * 布尔值
   */
  private Boolean boolField;
  /**
   * 日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime dateField;
  /**
   * 枚举
   */
  private String enumField;
  /**
   * 多值枚举
   */
  private String enumssField;
  /**
   * gggg
   */
  private Long gggg;
  /**
   * ccd
   */
  private Long vvd;
  /**
   * ert
   */
  private Long eert;
  /**
   * hhhh
   */
  private Long hhh;
  /**
   * dfg
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime fdg;
  /**
   * ddddddd
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime ddddddd;

  /**
   * 对一关联关系 关联对象 testobject2
   */
  private Long tooneboId;

  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("shortTextField", shortTextField);
      map.put("longTextField", longTextField);
      map.put("urlField", urlField);
      map.put("emailField", emailField);
      map.put("phoneField", phoneField);
      map.put("areaField", areaField);
      map.put("stringsField", stringsField);
      map.put("serialNoField", serialNoField);
      map.put("intField", intField);
      map.put("stringField", stringField);
      map.put("decimalField", decimalField);
      map.put("amountField", amountField);
      map.put("percentField", percentField);
      map.put("boolField", boolField);
      map.put("dateField", BocpGenUtils.toTimestamp(dateField));
      map.put("enumField", enumField);
      map.put("enumssField", enumssField);
      map.put("gggg", gggg);
      map.put("vvd", vvd);
      map.put("eert", eert);
      map.put("hhh", hhh);
      map.put("fdg", BocpGenUtils.toTimestamp(fdg));
      map.put("ddddddd", BocpGenUtils.toTimestamp(ddddddd));

      map.put("toonebo.id", tooneboId);
      return map;
  }

  public static Testyace fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    Testyace entity = new Testyace();

    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("shortTextField")) {
      Object obj = map.get("shortTextField");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setShortTextField((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("longTextField")) {
      Object obj = map.get("longTextField");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setLongTextField((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("urlField")) {
      Object obj = map.get("urlField");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUrlField((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("emailField")) {
      Object obj = map.get("emailField");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setEmailField((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("phoneField")) {
      Object obj = map.get("phoneField");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPhoneField((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("areaField")) {
      Object obj = map.get("areaField");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAreaField((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("stringsField")) {
      Object obj = map.get("stringsField");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setStringsField((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("serialNoField")) {
      Object obj = map.get("serialNoField");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSerialNoField((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSerialNoField(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setSerialNoField(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("intField")) {
      Object obj = map.get("intField");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setIntField((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setIntField(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setIntField(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("stringField")) {
      Object obj = map.get("stringField");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setStringField((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("decimalField")) {
      Object obj = map.get("decimalField");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setDecimalField((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setDecimalField(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setDecimalField(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setDecimalField(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setDecimalField(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("amountField")) {
      Object obj = map.get("amountField");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmountField((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmountField(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmountField(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAmountField(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmountField(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("percentField")) {
      Object obj = map.get("percentField");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPercentField((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPercentField(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPercentField(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPercentField(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPercentField(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("boolField")) {
      Object obj = map.get("boolField");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setBoolField((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setBoolField(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("dateField")) {
      Object obj = map.get("dateField");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setDateField(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setDateField((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setDateField(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setDateField(null);
      }
    }
    if(map.containsKey("enumField")) {
      Object obj = map.get("enumField");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setEnumField((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("enumssField")) {
      Object obj = map.get("enumssField");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setEnumssField((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("gggg")) {
      Object obj = map.get("gggg");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setGggg((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setGggg(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setGggg(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("vvd")) {
      Object obj = map.get("vvd");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setVvd((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setVvd(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setVvd(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("eert")) {
      Object obj = map.get("eert");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setEert((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setEert(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setEert(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("hhh")) {
      Object obj = map.get("hhh");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setHhh((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setHhh(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setHhh(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("fdg")) {
      Object obj = map.get("fdg");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setFdg(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setFdg((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setFdg(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setFdg(null);
      }
    }
    if(map.containsKey("ddddddd")) {
      Object obj = map.get("ddddddd");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setDdddddd(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setDdddddd((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setDdddddd(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setDdddddd(null);
      }
    }

    if(map.containsKey("toonebo.id")) {
       Object obj = map.get("toonebo.id");
       if(obj instanceof Long) {
         entity.setTooneboId((Long)obj);
       } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
         entity.setTooneboId(Long.parseLong((String)obj));
       }
    }
    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("shortTextField")) {
      Object obj = map.get("shortTextField");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setShortTextField((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("longTextField")) {
      Object obj = map.get("longTextField");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setLongTextField((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("urlField")) {
      Object obj = map.get("urlField");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setUrlField((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("emailField")) {
      Object obj = map.get("emailField");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setEmailField((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("phoneField")) {
      Object obj = map.get("phoneField");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPhoneField((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("areaField")) {
      Object obj = map.get("areaField");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setAreaField((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("stringsField")) {
      Object obj = map.get("stringsField");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setStringsField((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("serialNoField")) {
      Object obj = map.get("serialNoField");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setSerialNoField((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setSerialNoField(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setSerialNoField(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("intField")) {
      Object obj = map.get("intField");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setIntField((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setIntField(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setIntField(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("stringField")) {
      Object obj = map.get("stringField");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setStringField((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("decimalField")) {
      Object obj = map.get("decimalField");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setDecimalField((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setDecimalField(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setDecimalField(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setDecimalField(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setDecimalField(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("amountField")) {
      Object obj = map.get("amountField");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setAmountField((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setAmountField(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setAmountField(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setAmountField(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setAmountField(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("percentField")) {
      Object obj = map.get("percentField");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setPercentField((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setPercentField(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setPercentField(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setPercentField(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setPercentField(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("boolField")) {
      Object obj = map.get("boolField");
      if(obj != null) {
        if(obj instanceof Boolean) {
            this.setBoolField((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setBoolField(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("dateField")) {
      Object obj = map.get("dateField");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setDateField(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setDateField((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setDateField(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setDateField(null);
      }
    }
    if(map.containsKey("enumField")) {
      Object obj = map.get("enumField");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setEnumField((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("enumssField")) {
      Object obj = map.get("enumssField");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setEnumssField((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("gggg")) {
      Object obj = map.get("gggg");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setGggg((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setGggg(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setGggg(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("vvd")) {
      Object obj = map.get("vvd");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setVvd((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setVvd(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setVvd(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("eert")) {
      Object obj = map.get("eert");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setEert((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setEert(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setEert(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("hhh")) {
      Object obj = map.get("hhh");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setHhh((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setHhh(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setHhh(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("fdg")) {
      Object obj = map.get("fdg");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setFdg(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setFdg((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setFdg(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setFdg(null);
      }
    }
    if(map.containsKey("ddddddd")) {
      Object obj = map.get("ddddddd");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setDdddddd(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setDdddddd((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setDdddddd(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setDdddddd(null);
      }
    }
  if(map.containsKey("toonebo.id")) {
    Object obj = map.get("toonebo.id");
    if(obj instanceof Long) {
        this.setTooneboId((Long)obj);
    } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
        this.setTooneboId(Long.parseLong((String)obj));
    }
  }
  }
}
