package com.xforceplus.ultraman.app.yaceyingyong.metadata.entity;

import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * zilei0711001
 * </p>
 *
 * @author ultraman
 * @since 2022-11-03
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class Zilei0711001 extends Fulei0711001 {

  /**
   * 字符串-子类
   */
  private String zfczl;
  /**
   * 字符串集合-子类
   */
  private String zfcjhzl;
  /**
   * 纯数字编号-子类
   */
  private Long cszbhzl;
  /**
   * 整型-子类
   */
  private Long zxzl;
  /**
   * 小数-子类
   */
  private BigDecimal xszl;
  /**
   * 金额-子类
   */
  private BigDecimal jinezl;
  /**
   * 布尔值-子类
   */
  private Boolean buerzhizl;
  /**
   * 日期-子类
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime riqizl;
  /**
   * meiju071101-zl
   */
  private String meiju071101zl;
  /**
   * dzmeiju071101-zl
   */
  private String dzmeiju071101zl;
  /**
   * 公式-子类
   */
  private String gongszl;
  /**
   * 自增编号-子类
   */
  private String zzbhzl;
  /**
   * id
   */
  private Long id;
  /**
   * 租户ID
   */
  private Long tenantId;
  /**
   * 租户代码
   */
  private String tenantCode;
  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;
  /**
   * 修改时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;
  /**
   * 创建人ID
   */
  private Long createUserId;
  /**
   * 修改人ID
   */
  private Long updateUserId;
  /**
   * 创建人名字
   */
  private String createUserName;
  /**
   * 修改人名字
   */
  private String updateUserName;
  /**
   * 删除标记
   */
  private String deleteFlag;


  public Map toOQSMap(){
      Map map = new HashMap();
      map.putAll(super.toOQSMap());
      map.put("zfczl", zfczl);
      map.put("zfcjhzl", zfcjhzl);
      map.put("cszbhzl", cszbhzl);
      map.put("zxzl", zxzl);
      map.put("xszl", xszl);
      map.put("jinezl", jinezl);
      map.put("buerzhizl", buerzhizl);
      map.put("riqizl", BocpGenUtils.toTimestamp(riqizl));
      map.put("meiju071101zl", meiju071101zl);
      map.put("dzmeiju071101zl", dzmeiju071101zl);
      map.put("gongszl", gongszl);
      map.put("zzbhzl", zzbhzl);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);

      return map;
  }

  public static Zilei0711001 fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    Zilei0711001 entity = new Zilei0711001();

    entity.setParentByOQSMap(map);
    if(map.containsKey("zfczl")) {
      Object obj = map.get("zfczl");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setZfczl((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("zfcjhzl")) {
      Object obj = map.get("zfcjhzl");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setZfcjhzl((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cszbhzl")) {
      Object obj = map.get("cszbhzl");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCszbhzl((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCszbhzl(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCszbhzl(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("zxzl")) {
      Object obj = map.get("zxzl");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setZxzl((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setZxzl(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setZxzl(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("xszl")) {
      Object obj = map.get("xszl");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setXszl((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setXszl(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setXszl(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setXszl(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setXszl(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("jinezl")) {
      Object obj = map.get("jinezl");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setJinezl((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setJinezl(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setJinezl(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setJinezl(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setJinezl(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("buerzhizl")) {
      Object obj = map.get("buerzhizl");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setBuerzhizl((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setBuerzhizl(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("riqizl")) {
      Object obj = map.get("riqizl");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setRiqizl(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setRiqizl((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setRiqizl(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setRiqizl(null);
      }
    }
    if(map.containsKey("meiju071101zl")) {
      Object obj = map.get("meiju071101zl");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setMeiju071101zl((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("dzmeiju071101zl")) {
      Object obj = map.get("dzmeiju071101zl");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDzmeiju071101zl((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("gongszl")) {
      Object obj = map.get("gongszl");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setGongszl((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("zzbhzl")) {
      Object obj = map.get("zzbhzl");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setZzbhzl((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }

    return entity;
  }

  protected void setParentByOQSMap(Map map) {
    super.setByOQSMap(map);
  }

  protected void setByOQSMap(Map map) {
    super.setByOQSMap(map);
    if(map.containsKey("zfczl")) {
      Object obj = map.get("zfczl");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setZfczl((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("zfcjhzl")) {
      Object obj = map.get("zfcjhzl");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setZfcjhzl((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cszbhzl")) {
      Object obj = map.get("cszbhzl");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCszbhzl((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCszbhzl(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCszbhzl(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("zxzl")) {
      Object obj = map.get("zxzl");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setZxzl((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setZxzl(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setZxzl(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("xszl")) {
      Object obj = map.get("xszl");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setXszl((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setXszl(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setXszl(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setXszl(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setXszl(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("jinezl")) {
      Object obj = map.get("jinezl");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setJinezl((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setJinezl(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setJinezl(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setJinezl(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setJinezl(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("buerzhizl")) {
      Object obj = map.get("buerzhizl");
      if(obj != null) {
        if(obj instanceof Boolean) {
            this.setBuerzhizl((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setBuerzhizl(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("riqizl")) {
      Object obj = map.get("riqizl");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setRiqizl(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setRiqizl((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setRiqizl(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setRiqizl(null);
      }
    }
    if(map.containsKey("meiju071101zl")) {
      Object obj = map.get("meiju071101zl");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setMeiju071101zl((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("dzmeiju071101zl")) {
      Object obj = map.get("dzmeiju071101zl");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDzmeiju071101zl((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("gongszl")) {
      Object obj = map.get("gongszl");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setGongszl((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("zzbhzl")) {
      Object obj = map.get("zzbhzl");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setZzbhzl((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
  }
}
