package com.xforceplus.ultraman.app.yangzheng23135.metadata.entity;

import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * testlookup042701
 * </p>
 *
 * @author ultraman
 * @since 2022-05-30
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class Testlookup042701 implements Serializable {

  private static final long serialVersionUID=1L;
  /**
   * zfc
   */
  private String zfc;
  /**
   * id
   */
  private Long id;
  /**
   * 租户ID
   */
  private Long tenantId;
  /**
   * 租户代码
   */
  private String tenantCode;
  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;
  /**
   * 修改时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;
  /**
   * 创建人ID
   */
  private Long createUserId;
  /**
   * 修改人ID
   */
  private Long updateUserId;
  /**
   * 创建人名字
   */
  private String createUserName;
  /**
   * 修改人名字
   */
  private String updateUserName;
  /**
   * 删除标记
   */
  private String deleteFlag;
  /**
   * lookupzfc1
   */
  private String lookupzfc1;
  /**
   * lookupzfc2
   */
  private String lookupzfc2;
  /**
   * lookupzfc3
   */
  private String lookupzfc3;
  /**
   * lookupmjx1
   */
  private String lookupmjx1;
  /**
   * lookupmjx2
   */
  private String lookupmjx2;
  /**
   * lookupmjx3
   */
  private String lookupmjx3;
  /**
   * lookupzfc-非默认值
   */
  private String lookupfeimorenzhi;
  /**
   * lookupcszbh1
   */
  private Long lookupcszbh1;
  /**
   * lookupjine1
   */
  private BigDecimal lookupjine1;
  /**
   * lookupzfc4
   */
  private String lookupzfc4;
  /**
   * lookupzx4
   */
  private Long lookupzx4;
  /**
   * lookupxs4
   */
  private BigDecimal lookupxs4;
  /**
   * lookupbez4
   */
  private Boolean lookupbez4;
  /**
   * lookupriqi4
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime lookupriqi4;
  /**
   * lookupmjx4
   */
  private String lookupmjx4;
  /**
   * lookupcszbh4
   */
  private Long lookupcszbh4;

  /**
   * 对一关联关系 关联对象 testbeilookup042701
   */
  private Long lookupguanxi0427001Id;
  /**
   * 对一关联关系 关联对象 testbeilookup042702
   */
  private Long lookupguanxi0427002Id;
  /**
   * 对一关联关系 关联对象 testbeilookup042703
   */
  private Long lookupguanxi0427003Id;
  /**
   * 对一关联关系 关联对象 testbeilookup042704
   */
  private Long lookup0505001Id;

  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("zfc", zfc);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("lookupzfc1", lookupzfc1);
      map.put("lookupzfc2", lookupzfc2);
      map.put("lookupzfc3", lookupzfc3);
      map.put("lookupmjx1", lookupmjx1);
      map.put("lookupmjx2", lookupmjx2);
      map.put("lookupmjx3", lookupmjx3);
      map.put("lookupfeimorenzhi", lookupfeimorenzhi);
      map.put("lookupcszbh1", lookupcszbh1);
      map.put("lookupjine1", lookupjine1);
      map.put("lookupzfc4", lookupzfc4);
      map.put("lookupzx4", lookupzx4);
      map.put("lookupxs4", lookupxs4);
      map.put("lookupbez4", lookupbez4);
      map.put("lookupriqi4", BocpGenUtils.toTimestamp(lookupriqi4));
      map.put("lookupmjx4", lookupmjx4);
      map.put("lookupcszbh4", lookupcszbh4);

      map.put("lookupguanxi0427001.id", lookupguanxi0427001Id);
      map.put("lookupguanxi0427002.id", lookupguanxi0427002Id);
      map.put("lookupguanxi0427003.id", lookupguanxi0427003Id);
      map.put("lookup0505001.id", lookup0505001Id);
      return map;
  }

  public static Testlookup042701 fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    Testlookup042701 entity = new Testlookup042701();

    if(map.containsKey("zfc")) {
      Object obj = map.get("zfc");
      if(obj != null) {
        if(obj instanceof String){
          entity.setZfc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("lookupzfc1")) {
      Object obj = map.get("lookupzfc1");
      if(obj != null) {
        if(obj instanceof String){
          entity.setLookupzfc1((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("lookupzfc2")) {
      Object obj = map.get("lookupzfc2");
      if(obj != null) {
        if(obj instanceof String){
          entity.setLookupzfc2((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("lookupzfc3")) {
      Object obj = map.get("lookupzfc3");
      if(obj != null) {
        if(obj instanceof String){
          entity.setLookupzfc3((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("lookupmjx1")) {
      Object obj = map.get("lookupmjx1");
      if(obj != null) {
        if(obj instanceof String){
          entity.setLookupmjx1((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("lookupmjx2")) {
      Object obj = map.get("lookupmjx2");
      if(obj != null) {
        if(obj instanceof String){
          entity.setLookupmjx2((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("lookupmjx3")) {
      Object obj = map.get("lookupmjx3");
      if(obj != null) {
        if(obj instanceof String){
          entity.setLookupmjx3((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("lookupfeimorenzhi")) {
      Object obj = map.get("lookupfeimorenzhi");
      if(obj != null) {
        if(obj instanceof String){
          entity.setLookupfeimorenzhi((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("lookupcszbh1")) {
      Object obj = map.get("lookupcszbh1");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setLookupcszbh1((Long)obj);
        } else if(obj instanceof String) {
          entity.setLookupcszbh1(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setLookupcszbh1(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("lookupjine1")) {
      Object obj = map.get("lookupjine1");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setLookupjine1((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setLookupjine1(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setLookupjine1(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setLookupjine1(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setLookupjine1(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("lookupzfc4")) {
      Object obj = map.get("lookupzfc4");
      if(obj != null) {
        if(obj instanceof String){
          entity.setLookupzfc4((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("lookupzx4")) {
      Object obj = map.get("lookupzx4");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setLookupzx4((Long)obj);
        } else if(obj instanceof String) {
          entity.setLookupzx4(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setLookupzx4(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("lookupxs4")) {
      Object obj = map.get("lookupxs4");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setLookupxs4((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setLookupxs4(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setLookupxs4(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setLookupxs4(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setLookupxs4(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("lookupbez4")) {
      Object obj = map.get("lookupbez4");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setLookupbez4((Boolean)obj);
        } else if(obj instanceof String) {
          entity.setLookupbez4(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("lookupriqi4")) {
      Object obj = map.get("lookupriqi4");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setLookupriqi4(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setLookupriqi4((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setLookupriqi4(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setLookupriqi4(null);
      }
    }
    if(map.containsKey("lookupmjx4")) {
      Object obj = map.get("lookupmjx4");
      if(obj != null) {
        if(obj instanceof String){
          entity.setLookupmjx4((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("lookupcszbh4")) {
      Object obj = map.get("lookupcszbh4");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setLookupcszbh4((Long)obj);
        } else if(obj instanceof String) {
          entity.setLookupcszbh4(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setLookupcszbh4(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }

    if(map.containsKey("lookupguanxi0427001.id")) {
       Object obj = map.get("lookupguanxi0427001.id");
       if(obj instanceof Long) {
         entity.setLookupguanxi0427001Id((Long)obj);
       } else if(obj instanceof String) {
         entity.setLookupguanxi0427001Id(Long.parseLong((String)obj));
       }
    }
    if(map.containsKey("lookupguanxi0427002.id")) {
       Object obj = map.get("lookupguanxi0427002.id");
       if(obj instanceof Long) {
         entity.setLookupguanxi0427002Id((Long)obj);
       } else if(obj instanceof String) {
         entity.setLookupguanxi0427002Id(Long.parseLong((String)obj));
       }
    }
    if(map.containsKey("lookupguanxi0427003.id")) {
       Object obj = map.get("lookupguanxi0427003.id");
       if(obj instanceof Long) {
         entity.setLookupguanxi0427003Id((Long)obj);
       } else if(obj instanceof String) {
         entity.setLookupguanxi0427003Id(Long.parseLong((String)obj));
       }
    }
    if(map.containsKey("lookup0505001.id")) {
       Object obj = map.get("lookup0505001.id");
       if(obj instanceof Long) {
         entity.setLookup0505001Id((Long)obj);
       } else if(obj instanceof String) {
         entity.setLookup0505001Id(Long.parseLong((String)obj));
       }
    }
    return entity;
  }


  protected void setByOQSMap(Map map){
    if(map.containsKey("zfc")) {
      Object obj = map.get("zfc");
      if(obj != null) {
        if(obj instanceof String){
            this.setZfc((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setId((Long)obj);
        } else if(obj instanceof String) {
            this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTenantId((Long)obj);
        } else if(obj instanceof String) {
            this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
            this.setTenantCode((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCreateTime(null);
      }
   }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setUpdateTime(null);
      }
   }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
            this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
            this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
            this.setCreateUserName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
            this.setUpdateUserName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
            this.setDeleteFlag((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("lookupzfc1")) {
      Object obj = map.get("lookupzfc1");
      if(obj != null) {
        if(obj instanceof String){
            this.setLookupzfc1((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("lookupzfc2")) {
      Object obj = map.get("lookupzfc2");
      if(obj != null) {
        if(obj instanceof String){
            this.setLookupzfc2((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("lookupzfc3")) {
      Object obj = map.get("lookupzfc3");
      if(obj != null) {
        if(obj instanceof String){
            this.setLookupzfc3((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("lookupmjx1")) {
      Object obj = map.get("lookupmjx1");
      if(obj != null) {
        if(obj instanceof String){
            this.setLookupmjx1((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("lookupmjx2")) {
      Object obj = map.get("lookupmjx2");
      if(obj != null) {
        if(obj instanceof String){
            this.setLookupmjx2((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("lookupmjx3")) {
      Object obj = map.get("lookupmjx3");
      if(obj != null) {
        if(obj instanceof String){
            this.setLookupmjx3((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("lookupfeimorenzhi")) {
      Object obj = map.get("lookupfeimorenzhi");
      if(obj != null) {
        if(obj instanceof String){
            this.setLookupfeimorenzhi((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("lookupcszbh1")) {
      Object obj = map.get("lookupcszbh1");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setLookupcszbh1((Long)obj);
        } else if(obj instanceof String) {
            this.setLookupcszbh1(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setLookupcszbh1(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("lookupjine1")) {
      Object obj = map.get("lookupjine1");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setLookupjine1((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setLookupjine1(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setLookupjine1(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
            this.setLookupjine1(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setLookupjine1(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
   }
    if(map.containsKey("lookupzfc4")) {
      Object obj = map.get("lookupzfc4");
      if(obj != null) {
        if(obj instanceof String){
            this.setLookupzfc4((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("lookupzx4")) {
      Object obj = map.get("lookupzx4");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setLookupzx4((Long)obj);
        } else if(obj instanceof String) {
            this.setLookupzx4(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setLookupzx4(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("lookupxs4")) {
      Object obj = map.get("lookupxs4");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setLookupxs4((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setLookupxs4(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setLookupxs4(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
            this.setLookupxs4(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setLookupxs4(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
   }
    if(map.containsKey("lookupbez4")) {
      Object obj = map.get("lookupbez4");
      if(obj != null) {
        if(obj instanceof Boolean) {
            this.setLookupbez4((Boolean)obj);
        } else if(obj instanceof String) {
            this.setLookupbez4(Boolean.valueOf((String)obj));
        }
      } else{
      }
   }
    if(map.containsKey("lookupriqi4")) {
      Object obj = map.get("lookupriqi4");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setLookupriqi4(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setLookupriqi4((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setLookupriqi4(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setLookupriqi4(null);
      }
   }
    if(map.containsKey("lookupmjx4")) {
      Object obj = map.get("lookupmjx4");
      if(obj != null) {
        if(obj instanceof String){
            this.setLookupmjx4((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("lookupcszbh4")) {
      Object obj = map.get("lookupcszbh4");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setLookupcszbh4((Long)obj);
        } else if(obj instanceof String) {
            this.setLookupcszbh4(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setLookupcszbh4(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }

  if(map.containsKey("lookupguanxi0427001.id")) {
    Object obj = map.get("lookupguanxi0427001.id");
    if(obj instanceof Long) {
        this.setLookupguanxi0427001Id((Long)obj);
    } else if(obj instanceof String) {
        this.setLookupguanxi0427001Id(Long.parseLong((String)obj));
    }
  }
  if(map.containsKey("lookupguanxi0427002.id")) {
    Object obj = map.get("lookupguanxi0427002.id");
    if(obj instanceof Long) {
        this.setLookupguanxi0427002Id((Long)obj);
    } else if(obj instanceof String) {
        this.setLookupguanxi0427002Id(Long.parseLong((String)obj));
    }
  }
  if(map.containsKey("lookupguanxi0427003.id")) {
    Object obj = map.get("lookupguanxi0427003.id");
    if(obj instanceof Long) {
        this.setLookupguanxi0427003Id((Long)obj);
    } else if(obj instanceof String) {
        this.setLookupguanxi0427003Id(Long.parseLong((String)obj));
    }
  }
  if(map.containsKey("lookup0505001.id")) {
    Object obj = map.get("lookup0505001.id");
    if(obj instanceof Long) {
        this.setLookup0505001Id((Long)obj);
    } else if(obj instanceof String) {
        this.setLookup0505001Id(Long.parseLong((String)obj));
    }
  }
  }

}
