package com.xforceplus.ultraman.app.yanzhenghuiguiyingyong.controller;


/**
 * eefeign客户端
 *
 * @author ultraman
 * @date 2021-10-09
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.yanzhenghuiguiyingyong.entity.Ee;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "yanzhenghuiguiyingyong")
public interface EeFeignApi {

  /**
   * 通过id查询ee
   * @param  id
   * @return R
   */
  @GetMapping("/ee/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增ee
   * @param ee ee
   * @return R
   */
  @PostMapping("/ee/add")
  public R save(@RequestBody Ee ee);

  /**
   * 修改ee
   * @param ee ee
   * @return R
   */
  @PostMapping("/ee/update")
  public R updateById(@RequestBody Ee ee);

  /**
   * 通过id删除ee
   * @param  id
   * @return R
   */
  @DeleteMapping("/ee/del/{id}" )
  public R removeById(@PathVariable Long id);

}