package com.xforceplus.ultraman.app.yanzhenghuiguiyingyong.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.yanzhenghuiguiyingyong.entity.Aa;
import com.xforceplus.ultraman.app.yanzhenghuiguiyingyong.service.IAaService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * aa前端控制器
 *
 * @author ultraman
 * @date 2021-10-13
 */
@RestController
public class AaController {

  @Autowired
  private IAaService aaServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param aa aa
   * @return
   */
  @GetMapping("/aas" )
  public XfR getAas(XfPage page, Aa aa) {
    return XfR.ok(aaServiceImpl.page(page, Wrappers.query(aa)));
  }

  /**
   * 通过id查询aa
   * @param  id
   * @return XfR
   */
  @GetMapping("/aas/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(aaServiceImpl.getById(id));
  }

  /**
   * 新增aa
   * @param aa aa
   * @return XfR
   */
  @PostMapping("/aas")
  public XfR save(@RequestBody Aa aa) {
     return XfR.ok(aaServiceImpl.save(aa));
  }

  /**
   * 修改-传入修改后的全部数据aa
   * @param aa aa
   * @return XfR
   */
  @PutMapping("/aas/{id}")
  public XfR putUpdate(@RequestBody Aa aa,@PathVariable Long id) {
      aa.setId(id);
      return XfR.ok(aaServiceImpl.updateById(aa));
  }

  /**
   * 修改-传入修改的数据aa
   * @param aa aa
   * @return XfR
   */
  @PatchMapping("/aas/{id}")
  public XfR patchUpdate(@RequestBody Aa aa,@PathVariable Long id) {
      Aa upaa = aaServiceImpl.getById(id);
      if(upaa != null){
        upaa = ObjectCopyUtils.copyProperties(aa,upaa,true);
      }
      return XfR.ok(aaServiceImpl.updateById(upaa));
  }

  /**
   * 通过id删除aa
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/aas/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(aaServiceImpl.removeById(id));
  }

  @PostMapping("/aas/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "aa");
     params.put("request", condition);

     return XfR.ok(aaServiceImpl.querys(params));
  }

}
