package com.xforceplus.ultraman.app.yanzhenghuiguiyingyong.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.yanzhenghuiguiyingyong.entity.Appidfunc;
import com.xforceplus.ultraman.app.yanzhenghuiguiyingyong.service.IAppidfuncService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * appid_func前端控制器
 *
 * @author ultraman
 * @date 2021-10-13
 */
@RestController
public class AppidfuncController {

  @Autowired
  private IAppidfuncService appidfuncServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param appidfunc appid_func
   * @return
   */
  @GetMapping("/appidfuncs" )
  public XfR getAppidfuncs(XfPage page, Appidfunc appidfunc) {
    return XfR.ok(appidfuncServiceImpl.page(page, Wrappers.query(appidfunc)));
  }

  /**
   * 通过id查询appid_func
   * @param  id
   * @return XfR
   */
  @GetMapping("/appidfuncs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(appidfuncServiceImpl.getById(id));
  }

  /**
   * 新增appid_func
   * @param appidfunc appid_func
   * @return XfR
   */
  @PostMapping("/appidfuncs")
  public XfR save(@RequestBody Appidfunc appidfunc) {
     return XfR.ok(appidfuncServiceImpl.save(appidfunc));
  }

  /**
   * 修改-传入修改后的全部数据appid_func
   * @param appidfunc appid_func
   * @return XfR
   */
  @PutMapping("/appidfuncs/{id}")
  public XfR putUpdate(@RequestBody Appidfunc appidfunc,@PathVariable Long id) {
      appidfunc.setId(id);
      return XfR.ok(appidfuncServiceImpl.updateById(appidfunc));
  }

  /**
   * 修改-传入修改的数据appid_func
   * @param appidfunc appid_func
   * @return XfR
   */
  @PatchMapping("/appidfuncs/{id}")
  public XfR patchUpdate(@RequestBody Appidfunc appidfunc,@PathVariable Long id) {
      Appidfunc upappidfunc = appidfuncServiceImpl.getById(id);
      if(upappidfunc != null){
        upappidfunc = ObjectCopyUtils.copyProperties(appidfunc,upappidfunc,true);
      }
      return XfR.ok(appidfuncServiceImpl.updateById(upappidfunc));
  }

  /**
   * 通过id删除appid_func
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/appidfuncs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(appidfuncServiceImpl.removeById(id));
  }

  @PostMapping("/appidfuncs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "appidfunc");
     params.put("request", condition);

     return XfR.ok(appidfuncServiceImpl.querys(params));
  }

}
