package com.xforceplus.ultraman.app.yanzhenghuiguiyingyong.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.yanzhenghuiguiyingyong.entity.Appidselfadd;
import com.xforceplus.ultraman.app.yanzhenghuiguiyingyong.service.IAppidselfaddService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * appid_selfadd前端控制器
 *
 * @author ultraman
 * @date 2021-10-13
 */
@RestController
public class AppidselfaddController {

  @Autowired
  private IAppidselfaddService appidselfaddServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param appidselfadd appid_selfadd
   * @return
   */
  @GetMapping("/appidselfadds" )
  public XfR getAppidselfadds(XfPage page, Appidselfadd appidselfadd) {
    return XfR.ok(appidselfaddServiceImpl.page(page, Wrappers.query(appidselfadd)));
  }

  /**
   * 通过id查询appid_selfadd
   * @param  id
   * @return XfR
   */
  @GetMapping("/appidselfadds/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(appidselfaddServiceImpl.getById(id));
  }

  /**
   * 新增appid_selfadd
   * @param appidselfadd appid_selfadd
   * @return XfR
   */
  @PostMapping("/appidselfadds")
  public XfR save(@RequestBody Appidselfadd appidselfadd) {
     return XfR.ok(appidselfaddServiceImpl.save(appidselfadd));
  }

  /**
   * 修改-传入修改后的全部数据appid_selfadd
   * @param appidselfadd appid_selfadd
   * @return XfR
   */
  @PutMapping("/appidselfadds/{id}")
  public XfR putUpdate(@RequestBody Appidselfadd appidselfadd,@PathVariable Long id) {
      appidselfadd.setId(id);
      return XfR.ok(appidselfaddServiceImpl.updateById(appidselfadd));
  }

  /**
   * 修改-传入修改的数据appid_selfadd
   * @param appidselfadd appid_selfadd
   * @return XfR
   */
  @PatchMapping("/appidselfadds/{id}")
  public XfR patchUpdate(@RequestBody Appidselfadd appidselfadd,@PathVariable Long id) {
      Appidselfadd upappidselfadd = appidselfaddServiceImpl.getById(id);
      if(upappidselfadd != null){
        upappidselfadd = ObjectCopyUtils.copyProperties(appidselfadd,upappidselfadd,true);
      }
      return XfR.ok(appidselfaddServiceImpl.updateById(upappidselfadd));
  }

  /**
   * 通过id删除appid_selfadd
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/appidselfadds/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(appidselfaddServiceImpl.removeById(id));
  }

  @PostMapping("/appidselfadds/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "appidselfadd");
     params.put("request", condition);

     return XfR.ok(appidselfaddServiceImpl.querys(params));
  }

}
