package com.xforceplus.ultraman.app.yanzhenghuiguiyingyong.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.yanzhenghuiguiyingyong.entity.Bb;
import com.xforceplus.ultraman.app.yanzhenghuiguiyingyong.service.IBbService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * bb前端控制器
 *
 * @author ultraman
 * @date 2021-10-13
 */
@RestController
public class BbController {

  @Autowired
  private IBbService bbServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param bb bb
   * @return
   */
  @GetMapping("/bbs" )
  public XfR getBbs(XfPage page, Bb bb) {
    return XfR.ok(bbServiceImpl.page(page, Wrappers.query(bb)));
  }

  /**
   * 通过id查询bb
   * @param  id
   * @return XfR
   */
  @GetMapping("/bbs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(bbServiceImpl.getById(id));
  }

  /**
   * 新增bb
   * @param bb bb
   * @return XfR
   */
  @PostMapping("/bbs")
  public XfR save(@RequestBody Bb bb) {
     return XfR.ok(bbServiceImpl.save(bb));
  }

  /**
   * 修改-传入修改后的全部数据bb
   * @param bb bb
   * @return XfR
   */
  @PutMapping("/bbs/{id}")
  public XfR putUpdate(@RequestBody Bb bb,@PathVariable Long id) {
      bb.setId(id);
      return XfR.ok(bbServiceImpl.updateById(bb));
  }

  /**
   * 修改-传入修改的数据bb
   * @param bb bb
   * @return XfR
   */
  @PatchMapping("/bbs/{id}")
  public XfR patchUpdate(@RequestBody Bb bb,@PathVariable Long id) {
      Bb upbb = bbServiceImpl.getById(id);
      if(upbb != null){
        upbb = ObjectCopyUtils.copyProperties(bb,upbb,true);
      }
      return XfR.ok(bbServiceImpl.updateById(upbb));
  }

  /**
   * 通过id删除bb
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/bbs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(bbServiceImpl.removeById(id));
  }

  @PostMapping("/bbs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "bb");
     params.put("request", condition);

     return XfR.ok(bbServiceImpl.querys(params));
  }

}
