package com.xforceplus.ultraman.app.yanzhenghuiguiyingyong.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.yanzhenghuiguiyingyong.entity.Cc;
import com.xforceplus.ultraman.app.yanzhenghuiguiyingyong.service.ICcService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * cc前端控制器
 *
 * @author ultraman
 * @date 2021-10-13
 */
@RestController
public class CcController {

  @Autowired
  private ICcService ccServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param cc cc
   * @return
   */
  @GetMapping("/ccs" )
  public XfR getCcs(XfPage page, Cc cc) {
    return XfR.ok(ccServiceImpl.page(page, Wrappers.query(cc)));
  }

  /**
   * 通过id查询cc
   * @param  id
   * @return XfR
   */
  @GetMapping("/ccs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(ccServiceImpl.getById(id));
  }

  /**
   * 新增cc
   * @param cc cc
   * @return XfR
   */
  @PostMapping("/ccs")
  public XfR save(@RequestBody Cc cc) {
     return XfR.ok(ccServiceImpl.save(cc));
  }

  /**
   * 修改-传入修改后的全部数据cc
   * @param cc cc
   * @return XfR
   */
  @PutMapping("/ccs/{id}")
  public XfR putUpdate(@RequestBody Cc cc,@PathVariable Long id) {
      cc.setId(id);
      return XfR.ok(ccServiceImpl.updateById(cc));
  }

  /**
   * 修改-传入修改的数据cc
   * @param cc cc
   * @return XfR
   */
  @PatchMapping("/ccs/{id}")
  public XfR patchUpdate(@RequestBody Cc cc,@PathVariable Long id) {
      Cc upcc = ccServiceImpl.getById(id);
      if(upcc != null){
        upcc = ObjectCopyUtils.copyProperties(cc,upcc,true);
      }
      return XfR.ok(ccServiceImpl.updateById(upcc));
  }

  /**
   * 通过id删除cc
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/ccs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(ccServiceImpl.removeById(id));
  }

  @PostMapping("/ccs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "cc");
     params.put("request", condition);

     return XfR.ok(ccServiceImpl.querys(params));
  }

}
