package com.xforceplus.ultraman.app.yanzhenghuiguiyingyong.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.yanzhenghuiguiyingyong.entity.Duozhimeij001;
import com.xforceplus.ultraman.app.yanzhenghuiguiyingyong.service.IDuozhimeij001Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * duozhimeij001前端控制器
 *
 * @author ultraman
 * @date 2021-10-13
 */
@RestController
public class Duozhimeij001Controller {

  @Autowired
  private IDuozhimeij001Service duozhimeij001ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param duozhimeij001 duozhimeij001
   * @return
   */
  @GetMapping("/duozhimeij001s" )
  public XfR getDuozhimeij001s(XfPage page, Duozhimeij001 duozhimeij001) {
    return XfR.ok(duozhimeij001ServiceImpl.page(page, Wrappers.query(duozhimeij001)));
  }

  /**
   * 通过id查询duozhimeij001
   * @param  id
   * @return XfR
   */
  @GetMapping("/duozhimeij001s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(duozhimeij001ServiceImpl.getById(id));
  }

  /**
   * 新增duozhimeij001
   * @param duozhimeij001 duozhimeij001
   * @return XfR
   */
  @PostMapping("/duozhimeij001s")
  public XfR save(@RequestBody Duozhimeij001 duozhimeij001) {
     return XfR.ok(duozhimeij001ServiceImpl.save(duozhimeij001));
  }

  /**
   * 修改-传入修改后的全部数据duozhimeij001
   * @param duozhimeij001 duozhimeij001
   * @return XfR
   */
  @PutMapping("/duozhimeij001s/{id}")
  public XfR putUpdate(@RequestBody Duozhimeij001 duozhimeij001,@PathVariable Long id) {
      duozhimeij001.setId(id);
      return XfR.ok(duozhimeij001ServiceImpl.updateById(duozhimeij001));
  }

  /**
   * 修改-传入修改的数据duozhimeij001
   * @param duozhimeij001 duozhimeij001
   * @return XfR
   */
  @PatchMapping("/duozhimeij001s/{id}")
  public XfR patchUpdate(@RequestBody Duozhimeij001 duozhimeij001,@PathVariable Long id) {
      Duozhimeij001 upduozhimeij001 = duozhimeij001ServiceImpl.getById(id);
      if(upduozhimeij001 != null){
        upduozhimeij001 = ObjectCopyUtils.copyProperties(duozhimeij001,upduozhimeij001,true);
      }
      return XfR.ok(duozhimeij001ServiceImpl.updateById(upduozhimeij001));
  }

  /**
   * 通过id删除duozhimeij001
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/duozhimeij001s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(duozhimeij001ServiceImpl.removeById(id));
  }

  @PostMapping("/duozhimeij001s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "duozhimeij001");
     params.put("request", condition);

     return XfR.ok(duozhimeij001ServiceImpl.querys(params));
  }

}
