package com.xforceplus.ultraman.app.yanzhenghuiguiyingyong.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.yanzhenghuiguiyingyong.entity.Huiguihotfix10;
import com.xforceplus.ultraman.app.yanzhenghuiguiyingyong.service.IHuiguihotfix10Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * huiguihotfix10前端控制器
 *
 * @author ultraman
 * @date 2021-10-13
 */
@RestController
public class Huiguihotfix10Controller {

  @Autowired
  private IHuiguihotfix10Service huiguihotfix10ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param huiguihotfix10 huiguihotfix10
   * @return
   */
  @GetMapping("/huiguihotfix10s" )
  public XfR getHuiguihotfix10s(XfPage page, Huiguihotfix10 huiguihotfix10) {
    return XfR.ok(huiguihotfix10ServiceImpl.page(page, Wrappers.query(huiguihotfix10)));
  }

  /**
   * 通过id查询huiguihotfix10
   * @param  id
   * @return XfR
   */
  @GetMapping("/huiguihotfix10s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(huiguihotfix10ServiceImpl.getById(id));
  }

  /**
   * 新增huiguihotfix10
   * @param huiguihotfix10 huiguihotfix10
   * @return XfR
   */
  @PostMapping("/huiguihotfix10s")
  public XfR save(@RequestBody Huiguihotfix10 huiguihotfix10) {
     return XfR.ok(huiguihotfix10ServiceImpl.save(huiguihotfix10));
  }

  /**
   * 修改-传入修改后的全部数据huiguihotfix10
   * @param huiguihotfix10 huiguihotfix10
   * @return XfR
   */
  @PutMapping("/huiguihotfix10s/{id}")
  public XfR putUpdate(@RequestBody Huiguihotfix10 huiguihotfix10,@PathVariable Long id) {
      huiguihotfix10.setId(id);
      return XfR.ok(huiguihotfix10ServiceImpl.updateById(huiguihotfix10));
  }

  /**
   * 修改-传入修改的数据huiguihotfix10
   * @param huiguihotfix10 huiguihotfix10
   * @return XfR
   */
  @PatchMapping("/huiguihotfix10s/{id}")
  public XfR patchUpdate(@RequestBody Huiguihotfix10 huiguihotfix10,@PathVariable Long id) {
      Huiguihotfix10 uphuiguihotfix10 = huiguihotfix10ServiceImpl.getById(id);
      if(uphuiguihotfix10 != null){
        uphuiguihotfix10 = ObjectCopyUtils.copyProperties(huiguihotfix10,uphuiguihotfix10,true);
      }
      return XfR.ok(huiguihotfix10ServiceImpl.updateById(uphuiguihotfix10));
  }

  /**
   * 通过id删除huiguihotfix10
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/huiguihotfix10s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(huiguihotfix10ServiceImpl.removeById(id));
  }

  @PostMapping("/huiguihotfix10s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "huiguihotfix10");
     params.put("request", condition);

     return XfR.ok(huiguihotfix10ServiceImpl.querys(params));
  }

}
