package com.xforceplus.ultraman.app.yanzhenghuiguiyingyong.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.yanzhenghuiguiyingyong.entity.Testhuigui;
import com.xforceplus.ultraman.app.yanzhenghuiguiyingyong.service.ITesthuiguiService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * testhuigui前端控制器
 *
 * @author ultraman
 * @date 2021-10-13
 */
@RestController
public class TesthuiguiController {

  @Autowired
  private ITesthuiguiService testhuiguiServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param testhuigui testhuigui
   * @return
   */
  @GetMapping("/testhuiguis" )
  public XfR getTesthuiguis(XfPage page, Testhuigui testhuigui) {
    return XfR.ok(testhuiguiServiceImpl.page(page, Wrappers.query(testhuigui)));
  }

  /**
   * 通过id查询testhuigui
   * @param  id
   * @return XfR
   */
  @GetMapping("/testhuiguis/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(testhuiguiServiceImpl.getById(id));
  }

  /**
   * 新增testhuigui
   * @param testhuigui testhuigui
   * @return XfR
   */
  @PostMapping("/testhuiguis")
  public XfR save(@RequestBody Testhuigui testhuigui) {
     return XfR.ok(testhuiguiServiceImpl.save(testhuigui));
  }

  /**
   * 修改-传入修改后的全部数据testhuigui
   * @param testhuigui testhuigui
   * @return XfR
   */
  @PutMapping("/testhuiguis/{id}")
  public XfR putUpdate(@RequestBody Testhuigui testhuigui,@PathVariable Long id) {
      testhuigui.setId(id);
      return XfR.ok(testhuiguiServiceImpl.updateById(testhuigui));
  }

  /**
   * 修改-传入修改的数据testhuigui
   * @param testhuigui testhuigui
   * @return XfR
   */
  @PatchMapping("/testhuiguis/{id}")
  public XfR patchUpdate(@RequestBody Testhuigui testhuigui,@PathVariable Long id) {
      Testhuigui uptesthuigui = testhuiguiServiceImpl.getById(id);
      if(uptesthuigui != null){
        uptesthuigui = ObjectCopyUtils.copyProperties(testhuigui,uptesthuigui,true);
      }
      return XfR.ok(testhuiguiServiceImpl.updateById(uptesthuigui));
  }

  /**
   * 通过id删除testhuigui
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/testhuiguis/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(testhuiguiServiceImpl.removeById(id));
  }

  @PostMapping("/testhuiguis/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "testhuigui");
     params.put("request", condition);

     return XfR.ok(testhuiguiServiceImpl.querys(params));
  }

}
