package com.xforceplus.ultraman.app.yanzhenghuiguiyingyong.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.yanzhenghuiguiyingyong.entity.Testobject1;
import com.xforceplus.ultraman.app.yanzhenghuiguiyingyong.service.ITestobject1Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * feature1前端控制器
 *
 * @author ultraman
 * @date 2021-10-13
 */
@RestController
public class Testobject1Controller {

  @Autowired
  private ITestobject1Service testobject1ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param testobject1 feature1
   * @return
   */
  @GetMapping("/testobject1s" )
  public XfR getTestobject1s(XfPage page, Testobject1 testobject1) {
    return XfR.ok(testobject1ServiceImpl.page(page, Wrappers.query(testobject1)));
  }

  /**
   * 通过id查询feature1
   * @param  id
   * @return XfR
   */
  @GetMapping("/testobject1s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(testobject1ServiceImpl.getById(id));
  }

  /**
   * 新增feature1
   * @param testobject1 feature1
   * @return XfR
   */
  @PostMapping("/testobject1s")
  public XfR save(@RequestBody Testobject1 testobject1) {
     return XfR.ok(testobject1ServiceImpl.save(testobject1));
  }

  /**
   * 修改-传入修改后的全部数据feature1
   * @param testobject1 feature1
   * @return XfR
   */
  @PutMapping("/testobject1s/{id}")
  public XfR putUpdate(@RequestBody Testobject1 testobject1,@PathVariable Long id) {
      testobject1.setId(id);
      return XfR.ok(testobject1ServiceImpl.updateById(testobject1));
  }

  /**
   * 修改-传入修改的数据feature1
   * @param testobject1 feature1
   * @return XfR
   */
  @PatchMapping("/testobject1s/{id}")
  public XfR patchUpdate(@RequestBody Testobject1 testobject1,@PathVariable Long id) {
      Testobject1 uptestobject1 = testobject1ServiceImpl.getById(id);
      if(uptestobject1 != null){
        uptestobject1 = ObjectCopyUtils.copyProperties(testobject1,uptestobject1,true);
      }
      return XfR.ok(testobject1ServiceImpl.updateById(uptestobject1));
  }

  /**
   * 通过id删除feature1
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/testobject1s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(testobject1ServiceImpl.removeById(id));
  }

  @PostMapping("/testobject1s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "testobject1");
     params.put("request", condition);

     return XfR.ok(testobject1ServiceImpl.querys(params));
  }

}
