package com.xforceplus.ultraman.app.yanzhenghuiguiyingyong.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.yanzhenghuiguiyingyong.entity.Testobject2;
import com.xforceplus.ultraman.app.yanzhenghuiguiyingyong.service.ITestobject2Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * fulei前端控制器
 *
 * @author ultraman
 * @date 2021-10-13
 */
@RestController
public class Testobject2Controller {

  @Autowired
  private ITestobject2Service testobject2ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param testobject2 fulei
   * @return
   */
  @GetMapping("/testobject2s" )
  public XfR getTestobject2s(XfPage page, Testobject2 testobject2) {
    return XfR.ok(testobject2ServiceImpl.page(page, Wrappers.query(testobject2)));
  }

  /**
   * 通过id查询fulei
   * @param  id
   * @return XfR
   */
  @GetMapping("/testobject2s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(testobject2ServiceImpl.getById(id));
  }

  /**
   * 新增fulei
   * @param testobject2 fulei
   * @return XfR
   */
  @PostMapping("/testobject2s")
  public XfR save(@RequestBody Testobject2 testobject2) {
     return XfR.ok(testobject2ServiceImpl.save(testobject2));
  }

  /**
   * 修改-传入修改后的全部数据fulei
   * @param testobject2 fulei
   * @return XfR
   */
  @PutMapping("/testobject2s/{id}")
  public XfR putUpdate(@RequestBody Testobject2 testobject2,@PathVariable Long id) {
      testobject2.setId(id);
      return XfR.ok(testobject2ServiceImpl.updateById(testobject2));
  }

  /**
   * 修改-传入修改的数据fulei
   * @param testobject2 fulei
   * @return XfR
   */
  @PatchMapping("/testobject2s/{id}")
  public XfR patchUpdate(@RequestBody Testobject2 testobject2,@PathVariable Long id) {
      Testobject2 uptestobject2 = testobject2ServiceImpl.getById(id);
      if(uptestobject2 != null){
        uptestobject2 = ObjectCopyUtils.copyProperties(testobject2,uptestobject2,true);
      }
      return XfR.ok(testobject2ServiceImpl.updateById(uptestobject2));
  }

  /**
   * 通过id删除fulei
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/testobject2s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(testobject2ServiceImpl.removeById(id));
  }

  @PostMapping("/testobject2s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "testobject2");
     params.put("request", condition);

     return XfR.ok(testobject2ServiceImpl.querys(params));
  }

}
